package restcontroller.sysmanage.develop.sysmsg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.management.OperatingSystemMXBean;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.parameter.License;
import common.parameter.parameter;
import restcontroller.R;
import utility.tools.Math;

import java.io.File;
import java.lang.management.*;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.*;

import static common.data.db.DBConnectPool.useingConnectionkeyMap;

public class sysmsg extends Controller {
    public sysmsg(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "垃圾回收", apiversion = R.ID10026001.v1.class, intervaltime = 1000 * 5)
    public String gc() throws YosException {
        System.gc();
        return getSucReturnObject().toString();
    }

    @API(title = "系统监控", apiversion = R.ID10024601.v1.class)
    public String getMsg() throws YosException {
        JSONObject object = new JSONObject();
        {
            JSONObject yosObject = new JSONObject();
            String datetime = "";
            String version = "";

            ClassLoader classLoader = sysmsg.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader) classLoader).getURLs();
                for (URL url : urls) {
                    String filepath = url.getFile();
                    if (filepath.contains("yos.core") && !filepath.contains("sources")) {
                        File file = new File(filepath);
                        datetime = getDateTime_Str(file.lastModified());
                        version = file.getName().replace("yos.core", "").replace("-", "").replace(".jar", "");
                    }
                }
            }
            yosObject.put("datetime", datetime);
            yosObject.put("version", version);
            object.put("yos", yosObject);
        }
        {
            License license = License.get();
            JSONObject yosObject = new JSONObject();
            yosObject.put("VerifyDays", license.getVerifyDays());
            yosObject.put("LicenseType", license.getLicenseType());
            yosObject.put("Customer", license.getCustomer());
            yosObject.put("MaxDBConCount", license.getMaxDBConCount());
            yosObject.put("ExpiresDate", getDate_Str(license.getExpiresDate()));
            object.put("yoslicense", yosObject);
        }
        {
            OperatingSystemMXBean system = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();

            JSONObject systemObject = new JSONObject();
            systemObject.put("Name", system.getName());
            systemObject.put("Version", system.getVersion());
            systemObject.put("Arch", system.getArch());
            systemObject.put("TotalPhysicalMemorySize", Math.div(system.getTotalPhysicalMemorySize(), 1024D * 1024D, 2));
            systemObject.put("FreePhysicalMemorySize", Math.div(system.getFreePhysicalMemorySize(), 1024D * 1024D, 2));
            systemObject.put("PhysicalMemoryUseRate", 1.000000 - Math.div(system.getFreePhysicalMemorySize(), system.getTotalPhysicalMemorySize(), 6));
            systemObject.put("ProcessCpuLoad", Math.mul(system.getProcessCpuLoad(), 100, 2));
            systemObject.put("SystemCpuLoad", Math.mul(system.getSystemCpuLoad(), 100, 2));
            try {
                systemObject.put("HostName", InetAddress.getLocalHost().getHostName());
            } catch (Exception e) {
                e.printStackTrace();
            }
            systemObject.put("AvailableProcessors", system.getAvailableProcessors());
            object.put("system", systemObject);
        }

        {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            JSONObject javaObject = new JSONObject();
            javaObject.put("PID", runtime.getName().split("@")[0]);
            //javaObject.put("SpecName", runtime.getSpecName());
            //javaObject.put("SpecVendor", runtime.getSpecVendor());
            javaObject.put("SpecVersion", runtime.getSpecVersion());
            javaObject.put("StartTime", getDateTime_Str(runtime.getStartTime()));
            //javaObject.put("VmName", runtime.getVmName());
            //javaObject.put("VmVendor", runtime.getVmVendor());
            javaObject.put("VmVersion", runtime.getVmVersion());

            double totalMemory = 0d;
            try {
                List<String> args = runtime.getInputArguments();
                if (args != null && !args.isEmpty()) {
                    for (String arg : args) {
                        arg = arg.toLowerCase();
                        if (arg.contains("-xmx")) {
                            arg = arg.replace("-xmx", "").replace("-", "");
                            if (arg.contains("mb")) {
                                totalMemory = Math.div(Double.parseDouble(arg.replace("mb", "")), 1024, 2);
                            } else if (arg.contains("m")) {
                                totalMemory = Math.div(Double.parseDouble(arg.replace("m", "")), 1024, 2);
                            } else if (arg.contains("gb")) {
                                totalMemory = Double.parseDouble(arg.replace("gb", ""));
                            } else if (arg.contains("g")) {
                                totalMemory = Double.parseDouble(arg.replace("g", ""));
                            }
                            break;
                        }
                    }
                }
            } finally {
                if (totalMemory > 0) {
                    javaObject.put("totalMemory", totalMemory);
                } else {
                    javaObject.put("totalMemory", Math.div(Runtime.getRuntime().maxMemory(), 1024D * 1024D * 1024D, 2));
                }
            }
            long runtitme = runtime.getUptime();
            String timestr = "";
            long daytimes = 86400000;
            if (runtitme / daytimes > 0) {
                timestr = runtitme / daytimes + "天";
                runtitme = runtitme % daytimes;
            }
            long hourtimes = 3600000;
            if (runtitme / hourtimes > 0) {
                timestr = timestr + runtitme / hourtimes + "小时";
                runtitme = runtitme % hourtimes;
            }
            long mtimes = 60000;
            if (!timestr.contains("天") && runtitme / mtimes > 0) {
                timestr = timestr + runtitme / mtimes + "分";
            }
            javaObject.put("UpTime", timestr);

            JSONObject array = new JSONObject();
            List<GarbageCollectorMXBean> garbages = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean g : garbages) {
                JSONObject object1 = new JSONObject();
                object1.put("count", g.getCollectionCount());
                object1.put("time", g.getCollectionTime());
                array.put(g.getName().replace(" ", ""), object1);
            }
            javaObject.put("GarbageCollector", array);

            JSONObject MemoryUsageObject = new JSONObject();

            MemoryUsageObject.put("NonHeap", JSON.toJSON(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
            MemoryUsageObject.put("Heap", JSON.toJSON(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
            javaObject.put("MemoryUsage", MemoryUsageObject);

            List<MemoryPoolMXBean> memoryPoolMXBeansList = ManagementFactory.getMemoryPoolMXBeans();
            JSONObject memoryPoolMXBeansObject = new JSONObject();
            for (MemoryPoolMXBean m : memoryPoolMXBeansList) {
                String poolname = m.getName().replace(" ", "");
//                if (Arrays.asList(new String[]{"CodeCache", "Metaspace", "CompressedClassSpace"}).contains(poolname)) {
//                    continue;
//                }
                memoryPoolMXBeansObject.put(poolname, JSON.toJSON(m.getUsage()));
            }
            javaObject.put("MemoryPool", memoryPoolMXBeansObject);
            object.put("java", javaObject);
        }
        {
            ThreadMXBean thread = ManagementFactory.getThreadMXBean();
            JSONObject threadObject = new JSONObject();
            threadObject.put("threadCount", thread.getThreadCount());
            threadObject.put("peakThreadCount", thread.getPeakThreadCount());

            long[] deadlockedIds = thread.findDeadlockedThreads();
            if (deadlockedIds != null && deadlockedIds.length > 0) {
                threadObject.put("deadlockedthreads", JSON.toJSON(thread.getThreadInfo(deadlockedIds)));
            } else {
                threadObject.put("deadlockedthreads", new JSONArray());
            }
            object.put("threads", threadObject);
        }

        {
            JSONObject mysqlObject = new JSONObject();
            mysqlObject.put("Version", dbConnect.runSqlQuery("select version() as version ").get(0).getString("version"));

            Rows variableRows = dbConnect.runSqlQuery("show variables where Variable_name in('innodb_buffer_pool_size','innodb_log_file_size','innodb_log_buffer_size','key_buffer_size','tmp_table_size','read_buffer_size','sort_buffer_size','read_rnd_buffer_size')");
            mysqlObject.put("Variables", variableRows);

            JSONArray processArray = new JSONArray();
            Rows processRows = dbConnect.runSqlQuery("SHOW full PROCESSLIST");
            for (Row processRow : processRows) {
                if (processRow.getString("User").equalsIgnoreCase("event_scheduler")) {
                    continue;
                }
                JSONObject ProcessObject = new JSONObject();
                ProcessObject.put("User", processRow.getString("User"));
                ProcessObject.put("Command", processRow.getString("Command"));
                ProcessObject.put("State", processRow.getString("State"));
                ProcessObject.put("Time", processRow.getString("Time"));
                ProcessObject.put("Id", processRow.getLong("Id"));
                ProcessObject.put("Info", processRow.getString("Info"));
                ProcessObject.put("db", processRow.getString("db"));
                if (common.data.db.DBConnectPool.connectionIDList.contains(processRow.getLong("Id"))) {
                    ProcessObject.put("from", "yos");
                } else {
                    ProcessObject.put("from", "other");
                }
                processArray.add(ProcessObject);
            }
            processArray.sort(new Comparator<Object>() {
                @Override
                public int compare(Object o1, Object o2) {
                    JSONObject object1 = (JSONObject) o1;
                    JSONObject object2 = (JSONObject) o2;
                    String Command_o1 = "";
                    String Command_o2 = "";
                    String From_o1 = "";
                    String From_o2 = "";
                    try {
                        Command_o1 = object1.getString("Command");
                        Command_o2 = object2.getString("Command");
                        From_o1 = object1.getString("from");
                        From_o2 = object2.getString("from");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (From_o1.equals("yos") && !From_o1.equals(From_o2)) {
                        return -2;
                    } else if (!Command_o1.equals("Sleep") && !Command_o2.equals(Command_o1)) {
                        return -1;
                    } else if (Command_o1.equals(Command_o2)) {
                        return 0;
                    } else {
                        return 1;
                    }
                }
            });
            mysqlObject.put("Processlist", processArray);
            int ConnectPoolsSize = DBConnectPool.POOLS_MAP.get("default").size();
            int ConnectTotalCount = ConnectPoolsSize + useingConnectionkeyMap.get("default").size();
            mysqlObject.put("ConnectPoolsSize", ConnectPoolsSize == 0 ? ConnectPoolsSize : ConnectPoolsSize - 1);
            mysqlObject.put("ConnectTotalCount", ConnectTotalCount);
            object.put("mysql", mysqlObject);
        }
        {
            Long[] usersiteids = parameter.websocketClients.keySet().toArray(new Long[0]);
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
            querySQL.addJoinTable(JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
            querySQL.setWhere("usersiteid", usersiteids);
            Rows loginuserrows = querySQL.query();
            object.put("loginusers", loginuserrows);
        }
        {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
            querySQL.addJoinTable(JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
            querySQL.addJoinTable(JOINTYPE.inner, "sys_userrequestlog", "sys_userrequestlog", "usersiteid=:usersiteid");
            querySQL.addQueryFields("requesttimes", "sum(requesttimes)").addQueryFields("lastrequestdate", "max(lastrequestdate)");
            querySQL.addGroupBy();
            querySQL.setWhere("sys_userrequestlog.date=date_format(now(),'%Y-%m-%d')");
            Rows loginuserrows = querySQL.query();
            object.put("requestusers", loginuserrows);
        }
        {
            Rows rows = dbConnect.runSqlQuery("select postfix,count(0) filecount,sum(contentlength) as contentlength from sys_attachment group by postfix order by sum(contentlength) desc");
            for (Row row : rows) {
                double contentlength = row.getDouble("contentlength");
                if (contentlength / (1024 * 1024 * 1024) > 1) {
                    row.put("contentlength", Math.div(contentlength, (1024 * 1024 * 1024), 2) + " GB");
                } else if (contentlength / (1024 * 1024) > 1) {
                    row.put("contentlength", Math.div(contentlength, (1024 * 1024), 2) + " MB");
                } else if (contentlength / (1024) > 1) {
                    row.put("contentlength", Math.div(contentlength, (1024), 2) + " KB");
                } else {
                    row.put("contentlength", new Double(contentlength).longValue() + " byte");
                }
            }
            object.put("attachmentmsg", rows);
        }
        return getSucReturnObject().setData(object).toString();
    }
}
