package restcontroller.sysmanage.develop.datatag;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

@API(title = "企业数据标签预设管理")
public class datatag extends Controller {
    public datatag(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "标签分类查询", apiversion = R.ID10011701.v1.class)
    public String query_datatagList() throws YosException {
        Rows sys_systemtagRows = dbConnect.runSqlQuery("select sys_systemtagid,name,ownertable from sys_systemtag");
        for (Row row : sys_systemtagRows) {
            row.put("uniquecolumnname", getuniquecolumnname("ownertable"));
        }
        return getSucReturnObject().setData(sys_systemtagRows).toString();
    }

    @API(title = "标签分类新增修改", apiversion = R.ID10011801.v1.class)
    public String insertormodify_datatagList() throws YosException {
        long sys_systemtagid = content.getLongValue("sys_systemtagid");
        String name = content.getString("name");
        String ownertable = content.getString("ownertable");
        if (dbConnect.runSqlQuery("select *from sys_object where table_name='" + ownertable + "'").isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在表" + ownertable).toString();
        }
        if (content.getBooleanValue("isasync")) {
            Rows sys_systemtagRows = dbConnect.runSqlQuery("select *from sys_systemtag where ownertable='" + ownertable + "'");
            if (sys_systemtagRows.isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "标签分类新增");
                sqlFactory.addParameter("sys_systemtagid", createTableID("sys_systemtag"));
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("name", name);
                dbConnect.runSqlUpdate(sqlFactory);
            } else {
                sys_systemtagid = sys_systemtagRows.get(0).getLong("sys_systemtagid");
                SQLFactory sqlFactory = new SQLFactory(this, "标签分类修改");
                sqlFactory.addParameter("sys_systemtagid", sys_systemtagid);
                sqlFactory.addParameter("name", name);
                dbConnect.runSqlUpdate(sqlFactory);
            }
        } else {
            if (sys_systemtagid <= 0 || dbConnect.runSqlQuery("select *from sys_systemtag where sys_systemtagid=" + sys_systemtagid).isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "标签分类新增");
                sqlFactory.addParameter("sys_systemtagid", createTableID("sys_systemtag"));
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("name", name);
                dbConnect.runSqlUpdate(sqlFactory);
            } else {
                SQLFactory sqlFactory = new SQLFactory(this, "标签分类修改");
                sqlFactory.addParameter("sys_systemtagid", sys_systemtagid);
                sqlFactory.addParameter("name", name);
                dbConnect.runSqlUpdate(sqlFactory);
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "标签分类删除", apiversion = R.ID10011901.v1.class)
    public String delete_datatagList() throws YosException {
        long sys_systemtagid = content.getLongValue("sys_systemtagid");
        dbConnect.runSqlUpdate("delete from sys_systemtag where sys_systemtagid=" + sys_systemtagid);
        return getSucReturnObject().toString();
    }

}
