package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_helpdocs implements YosObject {
    @Override
    public String table_comment() {
        return "系统帮助文档表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_helpdocsid", "系统帮助文档表ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("doctype", "语言类型", "markdown、html", 50, false, false, false, "markdown", 3));
        arrayList.add(new DateTimeCol("createdate", "创建时间"));
        arrayList.add(new DateTimeCol("changedate", "修改时间"));
        arrayList.add(new VarcharCol("ownertable", "数据表", 50));
        arrayList.add(new BigIntCol("ownerid", "数据id"));
        arrayList.add(new VarcharCol("type", "类型", 50));
        arrayList.add(new LongTextCol("content", "内容"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
