package common.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import common.YosException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.math.BigDecimal;
import java.util.*;

public class Rows extends ArrayList<Row> {

    private static final long serialVersionUID = 1L;
    public long totalRows = 0;
    public long totalPage = 0;
    public String listqueryid = "";

    private ArrayList<String> fieldlist;
    private HashMap<String, FieldMeta> fieldMetaMap;

    public long getTotalRows() {
        return totalRows;
    }

    public long getTotalPage() {
        return totalPage;
    }

    public Row getRow(int index) {
        if (index + 1 > this.size()) {
            return null;
        }
        return super.get(index);
    }

    @Override
    public Row get(int index) {
        if (index + 1 > this.size()) {
            return null;
        }
        return super.get(index);
    }

    public Row getLastRow() {
        return get(this.size() - 1);
    }

    /**
     * 获取字段合计值
     *
     * @param column
     * @return
     */
    public BigDecimal sum(String column) {
        BigDecimal value = new BigDecimal("0");
        for (Row row : this) {
            if (row.containsKey(column)) {
                value = value.add(row.getBigDecimal(column));
            }
        }
        return value;
    }

    private HashMap<String, BigDecimal> minValueMap = new HashMap<String, BigDecimal>();
    private HashMap<String, BigDecimal> maxValueMap = new HashMap<String, BigDecimal>();

    /**
     * 获取字段最小值
     *
     * @param column
     * @return
     */
    public BigDecimal min(String column) {
        if (minValueMap.containsKey(column)) {
            return minValueMap.get(column);
        }
        caculate(column);
        return minValueMap.get(column);
    }

    /**
     * 获取字段最大值
     *
     * @param column
     * @return
     */
    public BigDecimal max(String column) {
        if (maxValueMap.containsKey(column)) {
            return maxValueMap.get(column);
        }
        caculate(column);
        return maxValueMap.get(column);
    }

    private void caculate(String column) {
        BigDecimal minvalue = new BigDecimal("0");
        BigDecimal maxvalue = new BigDecimal("0");
        for (Row row : this) {
            if (row.containsKey(column)) {
                BigDecimal value = row.getBigDecimal(column);
                minvalue = minvalue.min(value);
                maxvalue = maxvalue.max(value);
            }
        }
        minValueMap.put(column, minvalue);
        maxValueMap.put(column, maxvalue);
    }

    public Rows removeColumn(String[] columns) {
        for (Row row : this) {
            for (String column : columns) {
                row.remove(column);
            }
        }
        return this;
    }

    public JSONArray toJsonArray() {
        return (JSONArray) JSON.toJSON(this);
    }

    public JSONArray toJsonArray(String column) {
        JSONArray array = new JSONArray();
        for (Row row : this) {
            Object value = row.get(column);
            array.add(value);
        }
        return array;
    }

    public String[] toArray(String column) {
        return toArrayList(column).toArray(new String[0]);
    }

    public String[] toArray(String column, boolean isdistinct) {
        return toArrayList(column, isdistinct).toArray(new String[0]);
    }

    public ArrayList<String> toArrayList(String column) {
        return toArrayList(column, false);
    }

    public ArrayList<String> toArrayList(String column, boolean isdistinct) {
        ArrayList<String> list = new ArrayList<>();
        for (Row row : this) {
            String value = row.getString(column);
            if (!isdistinct || !list.contains(value)) {
                list.add(value);
            }
        }
        return list;
    }

    public ArrayList<ArrayList<Object>> toListList() {
        ArrayList<ArrayList<Object>> list = new ArrayList<>();
        for (Row row : this) {
            list.add(row.toList(getFieldList()));
        }
        return list;
    }

    public <T> T[] toArray(String column, T[] t) {
        return toArray(column, t, false);
    }

    public <T> T[] toArray(String column, T[] t, boolean isdistinct) {
        return toArrayList(column, new ArrayList<T>(), isdistinct).toArray(t);
    }

    public <T> ArrayList<T> toArrayList(String column, ArrayList<T> t) {
        return toArrayList(column, t, false);
    }

    public <T> ArrayList<T> toArrayList(String column, ArrayList<T> t, boolean isdistinct) {
        for (Row row : this) {
            Object value = row.get(column);
            if (!isdistinct || !t.contains(value)) {
                t.add((T) value);
            }
        }
        return t;
    }

    public RowsMap toRowsMap(String fieldname) {
        RowsMap map = new RowsMap();
        for (Row row : this) {
            String key = row.getString(fieldname);
            Rows subrows = null;
            if (map.containsKey(key)) {
                subrows = map.get(key);
            } else {
                subrows = new Rows();
            }
            subrows.add(row);
            map.put(key, subrows);
        }
        return map;
    }

    public RowsMap toRowsMap(String fieldnames[]) {
        RowsMap map = new RowsMap();
        for (Row row : this) {
            StringBuffer key = new StringBuffer();
            for (String fieldname : fieldnames) {
                key.append(row.getString(fieldname));
            }
            Rows subrows = null;
            if (map.containsKey(key.toString())) {
                subrows = map.get(key.toString());
            } else {
                subrows = new Rows();
            }
            subrows.add(row);
            map.put(key.toString(), subrows);
        }
        return map;
    }

    public String toXml() {
        Document document = DocumentHelper.createDocument();
        if (this.size() > 0) {
            Iterator<String> it = this.get(0).keySet().iterator();
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            Element root = document.addElement("rows");
            for (int i = 0; i < this.size(); i++) {
                Row row = getRow(i);
                Element element = root.addElement("row" + i);
                for (String key : list) {
                    Object value = row.get(key);
                    Element e = element.addElement(key);
                    if (value == null) {
                        e.addText("null");
                    } else {
                        e.addText(row.get(key).toString());
                    }
                }
            }
        }
        return document.asXML();
    }

    /**
     * 判断是否不为空
     *
     * @return
     */
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public void setFieldList(ArrayList<String> fieldlist) {
        this.fieldlist = fieldlist;
    }

    /**
     * 获取Rows所有的字段
     *
     * @return
     */
    public ArrayList<String> getFieldList() {
        return this.fieldlist;
    }

    public HashMap<String, FieldMeta> getFieldMetaMap() {
        return fieldMetaMap;
    }

    public FieldMeta getFieldMeta(String fieldname) {
        return fieldMetaMap.get(fieldname);
    }

    public ArrayList<String> getTableNames() {
        ArrayList<String> arrayList = new ArrayList<>();
        for (FieldMeta fieldMeta : fieldMetaMap.values()) {
            if (!arrayList.contains(fieldMeta.getTable_name())) {
                arrayList.add(fieldMeta.getTable_name());
            }
        }
        return arrayList;
    }

    public void setFieldMetaMap(HashMap<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    @Deprecated
    public void setFieldTypeMap(HashMap<String, Class> keytypemap) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<>();
        }
        for (String fieldname : keytypemap.keySet()) {
            FieldMeta fieldMeta = null;
            if (this.fieldMetaMap.containsKey(fieldname)) {
                fieldMeta = this.fieldMetaMap.get(fieldname);
            } else {
                fieldMeta = new FieldMeta();
            }
            fieldMeta.setFieldtype(keytypemap.get(fieldname));
            this.fieldMetaMap.put(fieldname, fieldMeta);
        }
    }

    public void sortby(String fieldname) {
        Class fieldclazztype = getFieldMeta(fieldname).getFieldtype();
        this.sort(new Comparator<Row>() {
            @Override
            public int compare(Row o1, Row o2) {
                if (fieldclazztype == Integer.class) {
                    return Integer.compare(o1.getInteger(fieldname), o2.getInteger(fieldname));
                } else if (fieldclazztype == Long.class) {
                    return Long.compare(o1.getLong(fieldname), o2.getLong(fieldname));
                } else if (fieldclazztype == Double.class) {
                    return Double.compare(o1.getDouble(fieldname), o2.getDouble(fieldname));
                } else if (fieldclazztype == Float.class) {
                    return Float.compare(o1.getFloat(fieldname), o2.getFloat(fieldname));
                } else if (fieldclazztype == Date.class) {
                    return Long.compare(o1.getDate(fieldname).getTime(), o2.getDate(fieldname).getTime());
                } else {
                    return o1.getString(fieldname).compareTo(o2.getString(fieldname));
                }
            }
        });
    }


    public void translate_simple(String languagecode, String... fieldnames) throws YosException {
        for (Row row : this) {
            row.translate_simple(languagecode, fieldnames);
        }
    }

    public void translate(String languagecode, String idcolumn, String... fieldnames) throws YosException {
        for (Row row : this) {
            row.translate(languagecode, idcolumn, fieldnames);
        }
    }
}
