package swing.controls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.QuerySQL;
import common.data.Rows;

import java.util.ArrayList;
import java.util.HashMap;

public class YTableData {
    private JSONArray dataArray;
    private ArrayList<HashMap<String, String>> fieldnamelist = new ArrayList<>();
    private ArrayList<Integer> fieldwidth = new ArrayList<>();
    private QuerySQL querySQL;
    private int pageSize = 10;
    private int pageNumber = 1;
    private Rows rows;
    private long totalRows = 0;
    private long totalPage = 0;

    public YTableData(JSONArray dataArray) {
        this.dataArray = dataArray;
    }

    public YTableData(Rows rows) {
        this.rows = rows;
    }

    public YTableData(QuerySQL querySQL) throws YosException {
        this.querySQL = querySQL;
    }

    public void loadData() throws YosException {
        if (this.querySQL != null) {
            this.querySQL.setPage(this.pageSize, this.pageNumber);
            this.rows = this.querySQL.query();
            this.totalRows = rows.getTotalRows();
            this.totalPage = rows.getTotalPage();
            this.dataArray = rows.toJsonArray();
        } else if (this.rows != null) {
            this.dataArray = rows.toJsonArray();
            this.totalRows = rows.getTotalRows();
            this.totalPage = rows.getTotalPage();
        }
    }

    public void setColumn(String fieldname, String title, int width) {
        if (fieldnamelist.isEmpty() && !fieldname.equals("selectflag")) {
            //添加选择框
            setColumn("selectflag", "", 1);
        }
        HashMap<String, String> fieldnamemap = new HashMap<>();
        fieldnamemap.put(fieldname, title);
        fieldnamelist.add(fieldnamemap);
        fieldwidth.add(width);
    }

    public void nextPage() {
        this.pageNumber = pageNumber + 1;
    }

    public void lastPage() {
        this.pageNumber = pageNumber - 1;
        this.pageNumber = this.pageNumber <= 0 ? 1 : this.pageNumber;
    }

    public void setPage(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber <= 0 ? 1 : pageNumber;
    }

    public void setTotal(long totalPage, long totalRows) {
        this.totalPage = totalPage;
        this.totalRows = totalRows;
    }

    public JSONArray getDataArray() {
        return this.dataArray;
    }

    public Object[][] getData() {
        Object[][] array = new Object[dataArray.size()][];
        int i = 0;
        for (Object object : dataArray) {
            JSONObject jsonObject = (JSONObject) object;
            jsonObject.put("selectflag", false);//选择框默认为非选择状态
            Object[] value = new Object[fieldnamelist.size()];
            int n = 0;
            for (HashMap<String, String> map : fieldnamelist) {
                for (String key : map.keySet()) {
                    value[n++] = jsonObject.get(key);
                }
            }
            array[i++] = value;
        }
        return array;
    }

    public Object[] getColname() {
        Object[] object = new Object[fieldnamelist.size()];
        int n = 0;
        for (HashMap<String, String> map : fieldnamelist) {
            for (String key : map.values()) {
                object[n++] = key;
            }
        }
        return object;
    }

    public ArrayList<Integer> getFieldwidth() {
        return fieldwidth;
    }

    public int getPageSize() {
        return pageSize;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public long getTotalRows() {
        return totalRows;
    }

    public long getTotalPage() {
        return totalPage;
    }
}
