package swing;

import swing.pluginunit.PluginUnit;

import javax.swing.*;

public class SystemInit {
    public void init() {
        setSystemStyle();

        /**
         * 小组件初始化
         */
        PluginUnit pluginUnit = new PluginUnit();
        pluginUnit.init();
    }

    public void setSystemStyle() {
        String lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";//默认
        //String lookAndFeel ="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";//Windows风格
        //String lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";// Windows Classic风格
        //String lookAndFeel ="com.sun.java.swing.plaf.motif.MotifLookAndFeel";//Motif风格
        // String lookAndFeel = "com.sun.java.swing.plaf.mac.MacLookAndFeel";//Mac风格
        // (需要在相关的操作系统上方可实现)
        // String lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";//GTK风格
        // (需要在相关的操作系统上方可实现)
        //String lookAndFeel =UIManager.getCrossPlatformLookAndFeelClassName();//可跨平台的默认风格
        //String lookAndFeel = UIManager.getSystemLookAndFeelClassName();//当前系统的风格
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        } catch (ClassNotFoundException | UnsupportedLookAndFeelException | IllegalAccessException | InstantiationException e1) {
            e1.printStackTrace();
        }
        // 全局字体大小
        UIManager.put("Button.font", YUIParameter.font_Formal);// 按钮
        UIManager.put("Label.font", YUIParameter.font_Formal);// 显示框
        UIManager.put("TextField.font", YUIParameter.font_Formal);// 输入库狂
        UIManager.put("PasswordField.font", YUIParameter.font_Formal);// 密码框
        UIManager.put("Table.font", YUIParameter.font_Formal);// 表格
        //UIManager.put("Panel.background",new Color(245, 247, 249));
        //UIManager.put("TableHeader.background",new Color(245, 247, 249));
    }

}
