package restcontroller.sysmanage.develop.services;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.InitService;
import common.ServiceController;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

import common.YosException;
import restcontroller.R;

@API(title = "管理端-开发-自动任务管理")
public class services extends Controller {
    public services(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "自动任务列表查询", apiversion = R.ID10016501.v1.class)
    public String query_servicelist() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_services order by isused desc,classname");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "自动任务新增，修改", apiversion = R.ID10016601.v1.class)
    public String insertormodify_service() throws YosException {
        long serviceid = content.getLongValue("serviceid");
        String classname = content.getString("classname");
        String remarks = content.getString("remarks");
        boolean isused = content.getBooleanValue("isused");
        String type = content.getStringValue("type");
        int count = content.getIntValue("count");
        String time = content.getStringValue("time");

        try {
            Class<?> clz = Class.forName("service." + classname);
            if (!clz.getSuperclass().equals(common.ServiceController.class)) {
                return getErrReturnObject().setErrMsg(classname + "不是有效的自动任务类").toString();
            }
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg(classname + "不是有效的自动任务类").toString();
        }
        SQLFactory sqlFactory = null;
        if (content.getBooleanValue("isasync")) {
            Rows sys_servicesRows = dbConnect.runSqlQuery("select *from sys_services where classname='" + classname + "'");
            if (sys_servicesRows.isEmpty()) {
                serviceid = createTableID("sys_services");
                sqlFactory = new SQLFactory(this, "自动任务新增");
                sqlFactory.addParameter("serviceid", serviceid);
                sqlFactory.addParameter("classname", classname);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("isused", isused);
                sqlFactory.addParameter("type", type);
                sqlFactory.addParameter("count", count);
                sqlFactory.addParameter("time", time);
            } else {
                serviceid = sys_servicesRows.get(0).getLong("serviceid");
                sqlFactory = new SQLFactory(this, "自动任务修改");
                sqlFactory.addParameter("serviceid", serviceid);
                sqlFactory.addParameter("classname", classname);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("isused", isused);
                sqlFactory.addParameter("type", type);
                sqlFactory.addParameter("count", count);
                sqlFactory.addParameter("time", time);
            }
            dbConnect.runSqlUpdate(sqlFactory);
            InitService.addService(dbConnect.runSqlQuery("select * from sys_services where serviceid=" + serviceid).get(0));
            return query_servicelist();
        } else {
            Rows sys_servicesRows = dbConnect.runSqlQuery("select * from sys_services where serviceid=" + serviceid);
            if (serviceid <= 0 || sys_servicesRows.isEmpty()) {
                serviceid = createTableID("sys_services");
                sqlFactory = new SQLFactory(this, "自动任务新增");
                sqlFactory.addParameter("serviceid", serviceid);
                sqlFactory.addParameter("classname", classname);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("isused", isused);
                sqlFactory.addParameter("type", type);
                sqlFactory.addParameter("count", count);
                sqlFactory.addParameter("time", time);
            } else {
                sqlFactory = new SQLFactory(this, "自动任务修改");
                sqlFactory.addParameter("serviceid", serviceid);
                sqlFactory.addParameter("classname", classname);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("isused", isused);
                sqlFactory.addParameter("type", type);
                sqlFactory.addParameter("count", count);
                sqlFactory.addParameter("time", time);
            }
            dbConnect.runSqlUpdate(sqlFactory);
            ServiceController.serviceed.remove(classname);
            InitService.addService(dbConnect.runSqlQuery("select * from sys_services where serviceid=" + serviceid).get(0));
            return query_servicelist();
        }
    }

    @API(title = "自动任务删除", apiversion = R.ID10016701.v1.class)
    public String delete_service() throws YosException {
        long serviceid = content.getLong("serviceid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_services where serviceid=" + serviceid);
        dbConnect.runSqlUpdate(list);
        return query_servicelist();
    }
}
