package restcontroller.sysmanage.develop.appregistry;

import beans.attachment.Attachment;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

public class system extends Controller {
    public system(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "开发端-系统应用注册-系统列表查询", apiversion = R.ID10007301.v1.class)
    public String querySystemList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select systemid,`system`,systemname,isused,sequence from sys_system order by sequence");
        for (Row row : rows) {
            row.put("iconurl", getSystemIconUrl(row.getLong("systemid"), "icon"));
            row.put("iconurl_mainnav", getSystemIconUrl(row.getLong("systemid"), "mainnavicon"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统信息新增修改", apiversion = R.ID10007401.v1.class)
    public String insertormodifySystem() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            String system = content.getString("system");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            if (dbConnect.runSqlQuery("select * from sys_system where `system`='" + system + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统新增");
                sqlFactory.addParameter("systemid", createTableID("sys_system"));
                sqlFactory.addParameter("system", system);
                sqlFactory.addParameter("systemname", systemname);
                sqlFactory.addParameter("sequence", 10);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_system set `system`='" + system + "', systemname='" + systemname + "',isused=" + isused + " where `system`='" + system + "'");
            }
        } else {
            int sequence = content.getIntValue("sequence");
            String system = content.getString("system");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            Rows sys_systemRows = dbConnect.runSqlQuery("select * from sys_system where `system`='" + system + "'");
            if (sys_systemRows.isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统新增");
                sqlFactory.addParameter("systemid", createTableID("sys_system"));
                sqlFactory.addParameter("system", system);
                sqlFactory.addParameter("systemname", systemname);
                sqlFactory.addParameter("sequence", 10);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_system set systemname='" + systemname + "',isused=" + isused + ",sequence=" + sequence + " where `system`='" + system + "'");
                systemIconUrlMap.remove(sys_systemRows.get(0).getString("systemid"));
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统信息删除", apiversion = R.ID10007501.v1.class)
    public String deleteSystem() throws YosException {
        long systemid = content.getLong("systemid");
        if (systemid == 0) {
            return getErrReturnObject().setErrMsg("该系统不可删除").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统已被使用不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_system where systemid=" + systemid);
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统端口列表查询", apiversion = R.ID10007601.v1.class)
    public String querySystemClientList() throws YosException {
        Rows rows;
        if (content.containsKey("systemid")) {
            long systemid = content.getLong("systemid");
            rows = dbConnect.runSqlQuery("select t1.systemid,t2.system,t2.systemname,t1.systemclientid,t1.systemclient,t1.systemclientname,t1.isused from sys_systemclient t1 " +
                    "inner join sys_system t2 on t1.systemid=t2.systemid " +
                    "where t1.systemid=" + systemid + " order by t2.sequence,t1.systemclientid");
        } else {
            rows = dbConnect.runSqlQuery("select t1.systemid,t2.system,t2.systemname,t1.systemclientid,t1.systemclient,t1.systemclientname,t1.isused from sys_systemclient t1 " +
                    "inner join sys_system t2 on t1.systemid=t2.systemid order by t2.sequence,t1.systemclientid");
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统操作端信息新增修改", apiversion = R.ID10007701.v1.class)
    public String insertormodifySystemClient() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            long systemclientid = content.getLong("systemclientid");
            String systemclient = content.getString("systemclient");
            String systemclientname = content.getString("systemclientname");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_system where systemid=" + systemid).isEmpty()) {
                return getErrReturnObject().setErrMsg("系统不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid + " and systemclient='" + systemclient + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统操作端新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("systemclientid", createTableID("sys_systemclient"));
                sqlFactory.addParameter("systemclient", systemclient);
                sqlFactory.addParameter("systemclientname", systemclientname);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemclient set systemid='" + systemid + "', systemclient='" + systemclient + "',systemclientname='" + systemclientname + "',isused=" + isused + " where systemid=" + systemid + " and systemclient='" + systemclient + "'");
            }
        } else {
            long systemid = content.getLong("systemid");
            long systemclientid = content.getLong("systemclientid");
            String systemclient = content.getString("systemclient");
            String systemclientname = content.getString("systemclientname");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_system where systemid=" + systemid).isEmpty()) {
                return getErrReturnObject().setErrMsg("系统不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid + " and systemclient='" + systemclient + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统操作端新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("systemclientid", createTableID("sys_systemclient"));
                sqlFactory.addParameter("systemclient", systemclient);
                sqlFactory.addParameter("systemclientname", systemclientname);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemclient set systemid='" + systemid + "', systemclient='" + systemclient + "',systemclientname='" + systemclientname + "',isused=" + isused + " where systemid=" + systemid + " and systemclient='" + systemclient + "'");
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-操作端删除", apiversion = R.ID10007801.v1.class)
    public String deleteSystemClient() throws YosException {
        long systemclientid = content.getLong("systemclientid");

        if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("操作端已被使用不可删除").toString();
        }
        if (systemclientid == 0) {
            return getErrReturnObject().setErrMsg("该操作端不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_systemclient where systemclientid=" + systemclientid);
        return getSucReturnObject().toString();
    }


    @API(title = "开发端-系统应用注册-系统模块信息列表查询", apiversion = R.ID10007901.v1.class)
    public String querySystemModuleList() throws YosException {
        Rows rows;
        if (content.containsKey("systemclientid")) {
            long systemclientid = content.getLong("systemclientid");
            rows = dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid + "  order by sequence");
            for (Row row : rows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));

                Rows coverRows_ = new Rows();
                Rows coverRows = Attachment.get(this, "sys_systemmodule", row.getLong("systemmoduleid"), "cover");
                for (Row coverRow : coverRows) {
                    if (!coverRows_.contains("siteid", coverRow.getString("siteid"))) {
                        coverRows_.add(coverRow);
                    }
                }
                row.put("cover", coverRows_);
            }
        } else {
            rows = dbConnect.runSqlQuery("select t3.systemname,t2.systemclientname,t1.systemmodulename,t1.systemmoduleid from sys_systemmodule t1 " +
                    "inner join sys_systemclient t2 on t1.systemclientid=t2.systemclientid " +
                    "inner join sys_system t3 on t2.systemid=t3.systemid " +
                    "order by t3.sequence,t1.sequence");
        }
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "开发端-系统应用注册-系统模块信息新增修改", apiversion = R.ID10008001.v1.class)
    public String insertormodifySystemmodule() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemclientid = content.getLong("systemclientid");
            long systemmoduleid = content.getLong("systemmoduleid");
            String systemmodule = content.getString("systemmodule");
            String systemmodulename = content.getString("systemmodulename");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                return getErrReturnObject().setErrMsg("操作端不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid + " and systemmodule='" + systemmodule + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统模块新增");
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemmoduleid", createTableID("sys_systemmodule"));
                sqlFactory.addParameter("systemmodule", systemmodule);
                sqlFactory.addParameter("systemmodulename", systemmodulename);
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemmodule set systemclientid='" + systemclientid + "', systemmodule='" + systemmodule + "',systemmodulename='" + systemmodulename + "',isused=" + isused + " where systemclientid=" + systemclientid + " and  systemmodule='" + systemmodule + "'");
            }
        } else {
            long systemclientid = content.getLong("systemclientid");
            long systemmoduleid = content.getLong("systemmoduleid");
            String systemmodule = content.getString("systemmodule");
            String systemmodulename = content.getString("systemmodulename");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                return getErrReturnObject().setErrMsg("操作端不存在").toString();
            }
            Rows sys_systemmoduleRows = dbConnect.runSqlQuery("select * from sys_systemmodule where systemmoduleid='" + systemmoduleid + "'");
            if (sys_systemmoduleRows.isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统模块新增");
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemmoduleid", createTableID("sys_systemmodule"));
                sqlFactory.addParameter("systemmodule", systemmodule);
                sqlFactory.addParameter("systemmodulename", systemmodulename);
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                systemModuleIconUrlMap.remove(sys_systemmoduleRows.get(0).getString("systemmoduleid"));
                dbConnect.runSqlUpdate("update sys_systemmodule set systemclientid='" + systemclientid + "', systemmodule='" + systemmodule + "',systemmodulename='" + systemmodulename + "',isused=" + isused + " where  systemmoduleid='" + systemmoduleid + "'");
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-模块删除", apiversion = R.ID10008101.v1.class)
    public String deleteSystemModule() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        if (dbConnect.runSqlQuery("select * from sys_systemapp where systemmoduleid=" + systemmoduleid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("模块已被使用不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_systemmodule where systemmoduleid=" + systemmoduleid);
        return getSucReturnObject().toString();
    }
}
