package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_systemapp_log implements YosObject {
    @Override
    public String table_comment() {
        return "应用访问日志表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_systemapp_logid", "数据ID");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new BigIntCol("systemappid", "应用ID"));
        list.add(new BigIntCol("userid", "用户ID"));
        list.add(new VarcharCol("siteid", "站点ID", 50));
        list.add(new DateCol("date", "日期"));
        list.add(new JsonCol("requesttime", "请求时间"));
        list.add(new BigIntCol("times", "请求次数"));
        return list;
    }
}
