package objectregister;

import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.awt.image.DataBuffer;
import java.util.ArrayList;

public class sys_dataauths implements YosObject {
    @Override
    public String table_comment() {
        return "数据授权表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return null;
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("ownertable", "所属表", 50));
        list.add(new BigIntCol("ownerid", "所属数据id"));
        list.add(new VarcharCol("siteid", "站点ID", 50));
        list.add(new BigIntCol("departmentid", "部门ID"));
        list.add(new BigIntCol("roleid", "角色ID"));
        list.add(new BigIntCol("hrid", "人员ID"));
        list.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID"));
        list.add(new BigIntCol("sa_saleareaid", "营销区域ID"));
        list.add(new BigIntCol("userid", "账号ID"));
        return list;
    }

    @Override
    public void DataInit() throws YosException {
        String view_name = "sys_dataauth_view";
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select table_name as table_name,view_definition as view_definition from information_schema.VIEWS where table_schema='" + dbConnect.getDBName() + "' and table_name='" + view_name + "'");
        if (rows.isEmpty()) {
            String sql = "SELECT DISTINCT t.siteid, t.ownertable, t.ownerid, tt.userid FROM " +
                    "(" +
                    "  SELECT t1.siteid, t1.ownertable, t1.ownerid, t1.authtype, t2.userid FROM sys_dataauth t1 " +
                    "  JOIN sys_dataauths t2 ON t1.siteid = t2.siteid AND t1.ownertable = t2.ownertable AND t1.ownerid = t2.ownerid " +
                    "  UNION ALL " +
                    "  SELECT t1.siteid, t1.ownertable, t1.ownerid, t1.authtype, t3.userid FROM sys_dataauth t1 " +
                    "  JOIN sys_dataauths t2 ON t1.siteid = t2.siteid AND t1.ownertable = t2.ownertable AND t1.ownerid = t2.ownerid " +
                    "  JOIN sys_userrole t3 ON t2.siteid = t3.siteid AND t2.roleid = t3.roleid " +
                    "  UNION ALL " +
                    "  SELECT t1.siteid, t1.ownertable, t1.ownerid, t1.authtype, t3.userid FROM sys_dataauth t1 " +
                    "  JOIN sys_dataauths t2 ON t1.siteid = t2.siteid AND t1.ownertable = t2.ownertable AND t1.ownerid = t2.ownerid " +
                    "  JOIN sys_hr t3 ON t2.siteid = t3.siteid AND (( t2.departmentid = t3.departmentid )  OR ( t2.hrid = t3.hrid )) " +
                    "  UNION ALL " +
                    "  SELECT t1.siteid, t1.ownertable, t1.ownerid, t1.authtype, t4.userid FROM sys_dataauth t1 " +
                    "  JOIN sys_dataauths t2 ON t1.siteid = t2.siteid AND t1.ownertable = t2.ownertable AND t1.ownerid = t2.ownerid " +
                    "  JOIN sa_salearea_hr t3 ON t2.siteid = t3.siteid AND t2.sa_saleareaid = t3.sa_saleareaid " +
                    "  JOIN sys_hr t4 ON t3.siteid = t4.siteid AND t3.hrid = t4.hrid " +
                    "  UNION ALL " +
                    "  SELECT t1.siteid, t1.ownertable, t1.ownerid, t1.authtype, t3.userid FROM sys_dataauth t1 " +
                    "  JOIN sys_dataauths t2 ON t1.siteid = t2.siteid AND t1.ownertable = t2.ownertable AND t1.ownerid = t2.ownerid " +
                    "  JOIN sys_enterprise_hr t3 ON t2.siteid = t3.siteid AND t2.sys_enterpriseid = t3.sys_enterpriseid " +
                    ") t " +
                    "JOIN sys_usersite tt ON t.siteid = tt.siteid AND ((t.authtype = 1 AND  tt.userid = t.userid ) OR (t.authtype = 0  AND  tt.userid <> t.userid ))";
            dbConnect.runSqlUpdate("CREATE VIEW " + view_name + " AS " + sql);
        }
    }

}
