package common.data.db;

import common.YosException;
import common.data.Rows;

import java.util.HashMap;
import java.util.Set;

public class SQLiteTable {
    private String tablename;

    public static SQLiteTable getTable(String tablename) {
        SQLiteTable sqLiteTable = new SQLiteTable();
        sqLiteTable.setTablename(tablename);
        return sqLiteTable;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return tablename;
    }

    public enum FieldType {
        VARCHAR, BIGINT, INT, DATE, DATETIME
    }


    HashMap<String, FieldType> map = new HashMap<>();

    public void addColumn(String columnname, FieldType fieldtype) {
        map.put(columnname, fieldtype);
    }

    public Set<String> keySet() {
        return map.keySet();
    }

    public FieldType getFieldType(String columnname) {
        return map.get(columnname);
    }

    public boolean dosNotExist() {
        return SQLiteMemory.runSqlQuery("SELECT * FROM sqlite_master WHERE type='table' AND name ='" + tablename + "'").isEmpty();
    }

    public void create() throws YosException {
        if (keySet().isEmpty()) {
            throw new YosException("没有为表" + tablename + "设置任何字段信息");
        }
        if (dosNotExist()) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("CREATE TABLE " + tablename + "(");
            Set<String> tableColumnSet = keySet();
            boolean isfirst = true;
            for (String columnname : tableColumnSet) {
                if (isfirst) {
                    sqlBuffer.append(columnname).append(" ").append(getFieldType(columnname).toString());
                    isfirst = false;
                } else {
                    sqlBuffer.append(",").append(columnname).append(" ").append(getFieldType(columnname).toString());
                }
            }
            sqlBuffer.append(");");
            SQLiteMemory.runSqlUpdate(sqlBuffer.toString());
        }
    }

    public SQLiteTableData makeData() {
        return new SQLiteTableData(this);
    }

    public Rows getData(String where) {
        if (where.contains("where")) {
            where = where.replace("where", "");
        }
        return SQLiteMemory.runSqlQuery("select * from " + tablename + " where " + where);
    }

    public void deleteData(String where) {
        if (where.contains("where")) {
            where = where.replace("where", "");
        }
        SQLiteMemory.runSqlUpdate("delete from " + tablename + " where " + where);
    }

    public void cleanTable() {
        SQLiteMemory.runSqlUpdate("delete from " + tablename + " where 1=1");
    }

    public void dropTable() {
        SQLiteMemory.runSqlUpdate("drop table " + tablename);
    }

}
