package beans.workreport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.data.Row;
import common.data.Rows;

public class WorkReport {
    /**
     * 工作汇报内容查询
     *
     * @param controller
     * @param sys_workreportpresetid 预设工作id
     * @return 工作明细
     * @throws YosException
     */
    public static Row getWorkReportContent(Controller controller, long sys_workreportpresetid) throws YosException {
        Rows rows = controller.dbConnect.runSqlQuery("select title,content,issql,editable from sys_workreportpreset where sys_workreportpresetid='" + sys_workreportpresetid + "'");
        if (rows.isNotEmpty()) {
            Row row = rows.get(0);
            if (row.getBoolean("issql")) {
                String sqlstr = row.getString("content");
                sqlstr = controller.SQLSystemParamHandle(sqlstr);
                if (!sqlstr.equals("")) {
                    Rows contentrows = controller.dbConnect.runSqlQuery(sqlstr);
                    row.put("content", contentrows);
                } else {
                    row.put("content", new JSONArray());
                }
            } else {
                JSONArray contentArray = new JSONArray();

                JSONObject contentObject = new JSONObject();
                contentObject.put("rowindex", 1);
                contentObject.put("content", row.getString("content"));

                contentArray.add(contentObject);

                row.put("content", contentArray);
            }
            row.remove("issql");
            return row;
        }
        return new Row();
    }
}
