package websocketcontroller.message;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.data.SQLFactory;
import common.parameter.parameter;
import common.websocket.WebSocket;
import utility.tools.Encryption;

import java.util.ArrayList;
import java.util.Calendar;

public class message extends Controller {

    /**
     * 构造函数
     *
     * @param content
     */
    public message(JSONObject content) throws YosException {
        super(content);
    }
    //String fmessagetype = content.getString("fmessagetype");//消息类型，text,file,data,image

    /**
     * 发送文字消息
     *
     * @return
     */
    public String sendTextMessage() throws YosException {
        long timdialogid = content.getLong("timdialogid");//对话框ID
        String fmessage = content.getString("fmessage");//消息

        JSONObject messageObject = new JSONObject();
        messageObject.put("timdialogid", timdialogid);
        messageObject.put("ftype", "text");
        messageObject.put("fdatetime", getDateTime_Str());
        messageObject.put("fmessageid", Encryption.Encode_MD5(siteid + userid + Calendar.getInstance().getTimeInMillis()));

        /**
         * 创建发送方信息
         */
        JSONObject sendfromObject = new JSONObject();
        sendfromObject.put("userid", userid);
        sendfromObject.put("siteid", siteid);
        sendfromObject.put("username", username);
        sendfromObject.put("headpic", getHeadPic(userid));
        messageObject.put("sendfrom", sendfromObject);

        JSONObject msgObject = new JSONObject();
        msgObject.put("fcontent", fmessage);
        messageObject.put("data", msgObject);

        ArrayList<Long> userids = getImDialogUserIds(timdialogid);
        for (long userid : userids) {
            if (parameter.websocketClients.containsKey(userid)) {
                for (WebSocket webSocket : parameter.websocketClients.get(userid).values()) {
                    webSocket.sendDialogMessage(messageObject);
                }
            }
        }
        saveMessage(messageObject, fmessage);
        return getSucReturnObject().toString();
    }

    /**
     * 发送文件消息
     *
     * @return
     */
    public String sendFileMessage() throws YosException {
        long timdialogid = content.getLong("timdialogid");//对话框ID
        long attachmentid = content.getLong("attachmentid");//附件ID

        JSONObject messageObject = new JSONObject();
        messageObject.put("timdialogid", timdialogid);
        messageObject.put("ftype", "file");
        messageObject.put("fdatetime", getDateTime_Str());
        messageObject.put("fmessageid", new Encryption().Encode_MD5(siteid + userid + Calendar.getInstance().getTimeInMillis()));

        /**
         * 创建发送方信息
         */
        JSONObject sendfromObject = new JSONObject();
        sendfromObject.put("userid", userid);
        sendfromObject.put("siteid", siteid);
        sendfromObject.put("username", username);
        sendfromObject.put("headpic", getHeadPic(userid));
        messageObject.put("sendfrom", sendfromObject);
        //messageObject.put("data", getAttachmentUrl(attachmentid));

        ArrayList<Long> userids = getImDialogUserIds(timdialogid);
        for (long userid : userids) {
            if (parameter.websocketClients.containsKey(userid)) {
                for (WebSocket webClientSocket : parameter.websocketClients.get(userid).values()) {
                    webClientSocket.sendDialogMessage(messageObject);
                }
            }
        }
        saveMessage(messageObject, "null");
        return getSucReturnObject().toString();
    }

    /**
     * 发送数据消息
     *
     * @return
     */
    public String sendDataMessage() throws YosException {
        long timdialogid = content.getLong("timdialogid");//对话框ID
        String ownertable = content.getString("ownertable");//数据表
        long ownerid = content.getLong("ownerid");//数据ID
        String ftype = content.getString("ftype");//数据类型

        JSONObject messageObject = new JSONObject();
        messageObject.put("timdialogid", timdialogid);
        messageObject.put("ftype", "data");
        messageObject.put("fdatetime", getDateTime_Str());
        messageObject.put("fmessageid", new Encryption().Encode_MD5(siteid + userid + Calendar.getInstance().getTimeInMillis()));

        /**
         * 创建发送方信息
         */
        JSONObject sendfromObject = new JSONObject();
        sendfromObject.put("userid", userid);
        sendfromObject.put("siteid", siteid);
        sendfromObject.put("username", username);
        sendfromObject.put("headpic", getHeadPic(userid));
        messageObject.put("sendfrom", sendfromObject);

        JSONObject msgObject = new JSONObject();
        msgObject.put("ownertable", ownertable);
        msgObject.put("ownerid", ownerid);
        msgObject.put("ftype", ftype);
        messageObject.put("data", msgObject);

        ArrayList<Long> userids = getImDialogUserIds(timdialogid);
        for (long userid : userids) {
            if (parameter.websocketClients.containsKey(userid)) {
                for (WebSocket webClientSocket : parameter.websocketClients.get(userid).values()) {
                    webClientSocket.sendDialogMessage(messageObject);
                }
            }
        }
        saveMessage(messageObject, "null");
        return getSucReturnObject().toString();
    }

    /**
     * 消息持久化
     *
     * @param messageObject
     */
    private void saveMessage(JSONObject messageObject, String fnotes) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "即时通讯群消息插入");
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("fnotes", fnotes);
        sqlFactory.addParameter("timdialogid", messageObject.getLong("timdialogid"));
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("fmessageobj", messageObject.toJSONString());
        sqlFactory.addParameter("fmessageid", messageObject.getString("messageid"));
        sqlFactory.addParameter("fmessagetype", messageObject.getString("ftype"));
        if ("data".equals(messageObject.getString("ftype"))) {
            sqlFactory.addParameter("ownerid", messageObject.getJSONObject("data").getString("ownerid"));
            sqlFactory.addParameter("ownertable", messageObject.getJSONObject("data").getString("ownertable"));
        } else {
            sqlFactory.addParameter("ownerid", "null");
            sqlFactory.addParameter("ownertable", "null");
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
    }
}
