package utility.bankdocking.zjrc;

import com.alibaba.fastjson.JSON;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import utility.bankdocking.zjrc.domain.InputHead;
import utility.bankdocking.zjrc.domain.IouInfos;
import utility.bankdocking.zjrc.domain.PageInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpConnService03 {


    /**
     * @param idType   证件类型
     * @param id       证件号
     * @param orderId  订单号
     * @param pageSize 每页数量
     * @param pageNum  页码
     * @return
     */
    public static PageInfo LoanApplication(String idType, String id, String orderId, String pageSize, String pageNum) {
        try {
            String url = "https://scm.zj96596.com/tpibench";

            Map<String, Object> map = new HashMap<String, Object>();

            InputHead head = new InputHead();
            head.setcONSUMER_SEQ_NO("002004" + head.gettRAN_DATE()
                    + head.gettRAN_TIMESTAMP() + "000001");
            head.setpLATNUM("PT202008187033");
            head.setsERVICE_CODE("400100003");
            map.put("head", head);

            Map<String, Object> body1 = new HashMap<String, Object>();
            body1.put("ID_TYPE", (idType == null || idType.length() <= 0) ? "" : idType);
            body1.put("ID", (id == null || id.length() <= 0) ? "" : id);
            body1.put("PAGE_SIZE", (pageSize == null || pageSize.length() <= 0) ? "" : pageSize);
            body1.put("PAGE_NUM", (pageNum == null || pageNum.length() <= 0) ? "" : pageNum);
            body1.put("ORDER_ID", (orderId == null || orderId.length() <= 0) ? "" : orderId);
            map.put("body", body1);

            String requestJson = JSON.toJSONString(map);//请求内容

            CloseableHttpClient client = (CloseableHttpClient) SSLClient.sslClient();
            HttpPost httpPost = new HttpPost(url);

            StringEntity stringEntity = new StringEntity(requestJson, "utf-8");
            stringEntity.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, "application/json"));
            httpPost.setEntity(stringEntity);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

            CloseableHttpResponse closeableHttpResponse = client.execute(httpPost);
            String response = "";
            HttpEntity entity = closeableHttpResponse.getEntity();
            if (entity != null) {
                response = EntityUtils.toString(entity, "utf-8");
            }
            EntityUtils.consume(entity);

            Map<String, Object> responseMap = JSON.parseObject(response);
            PageInfo pageInfo = new PageInfo();
            if (responseMap.get("body") != null) {
                Map<String, Object> bodymap = (Map<String, Object>) responseMap.get("body");
                if (bodymap.get("RECORD_COUNT") != null && ((String) bodymap.get("RECORD_COUNT")).length() != 0) {
                    pageInfo.setRecordCount(Long.parseLong((String) bodymap.get("RECORD_COUNT")));
                }
                if (bodymap.get("PAGE_SIZE") != null && ((String) bodymap.get("PAGE_SIZE")).length() != 0) {
                    pageInfo.setPageSize(Long.parseLong((String) bodymap.get("PAGE_SIZE")));
                }
                if (bodymap.get("PAGE_NUM") != null && ((String) bodymap.get("PAGE_NUM")).length() != 0) {
                    pageInfo.setPageNum(Long.parseLong((String) bodymap.get("PAGE_NUM")));
                }
                if (bodymap.get("PAGE_COUNT") != null && ((String) bodymap.get("PAGE_COUNT")).length() != 0) {
                    pageInfo.setPageCount(Long.parseLong((String) bodymap.get("PAGE_COUNT")));
                }
                if (bodymap.get("LIST") != null) {
                    List<IouInfos> list = JSON.parseArray(bodymap.get("LIST").toString(), IouInfos.class);
                    pageInfo.setList(list);
                }
            }
            closeableHttpResponse.close();
            return pageInfo;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
