package restcontroller.system.attachment;

import beans.datacontrllog.DataContrlLog;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "数据媒体附件管理")
public class Attachment extends Controller {

    public Attachment(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据媒体附件查询", notes = "指定type时查询相应的类型附件，否则查询所有附件", apiversion = R.ID10020401.v1.class)
    public String queryFileLink() throws YosException {
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLong("ownerid");
        Rows rows;
        String usetype;
        if (content.getBooleanValue("single")) {
            rows = getAttachmentUrl(content.getLongValue("attachmentid"));
        } else {
            if (content.containsKey("usetype") && !"".equals((usetype = content.getString("usetype")))) {
                rows = getAttachmentUrl(ownertable, ownerid, usetype);
            } else {
                rows = getAttachmentUrl(ownertable, ownerid);
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "创建数据附件媒体关联", apiversion = R.ID10020501.v1.class)
    public String createFileLink() throws YosException {
        String ownertable = content.getString("ownertable");
        Long ownerid = content.getLong("ownerid");
        String usetype = content.getString("usetype");//用途
        //查询已绑定的媒体ID
        ArrayList<String> allreadybindattachmentids = dbConnect.runSqlQuery("select attachmentid from sys_attachment_links where siteid='" + siteid + "' and usetype='" + usetype + "' and ownertable='" + ownertable + "' and ownerid='" + ownerid + "'").toArrayList("attachmentid");
        JSONArray attachmentids = content.getJSONArray("attachmentids");
        ArrayList<String> sqllist = new ArrayList<String>();
        ArrayList<Long> linksidList = new ArrayList<>();
        for (Object o : attachmentids) {
            String attachmentid = String.valueOf(o);
            if (!allreadybindattachmentids.contains(attachmentid)) {
                /*
                 *如果媒体ID未绑定数据，则执行绑定操作
                 */
                SQLFactory sql = new SQLFactory(this, "创建数据媒体关联");
                long linksid = createTableID("sys_attachment_links");
                linksidList.add(linksid);
                sql.addParameter("linksid", linksid);
                sql.addParameter("siteid", siteid);
                sql.addParameter("attachmentid", attachmentid);
                sql.addParameter("ownertable", ownertable);
                sql.addParameter("ownerid", ownerid);
                sql.addParameter("usetype", usetype);
                sql.addParameter("createby", username);
                sqllist.add(sql.getSQL());

                /*
                 *插入操作记录
                 */
                Rows rows = dbConnect.runSqlQuery("select document from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
                for (Row row : rows) {
                    sqllist.add(DataContrlLog.createLog(this, ownertable, ownerid, "上传附件", "上传附件" + row.getString("document")).getSQL());
                }
            }
        }
        dbConnect.runSqlUpdate(sqllist);
        if (ownertable.equals("sys_systemmodule")) {
            systemModuleIconUrlMap.clear();
        } else {
            cleanAllDataPool();
        }
        SQLFactory docfactory = new SQLFactory(this, "附件查询");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter("ownertable", ownertable);
        docfactory.addParameter_in("linksid", linksidList);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "删除数据媒体关联", apiversion = R.ID10020601.v1.class)
    public String deleteFileLink() throws YosException {
        JSONArray linksids = content.getJSONArray("linksids");
        ArrayList<String> sqllist = new ArrayList<String>();
        for (Object o : linksids) {
            String linksid = String.valueOf(o);
            SQLFactory sql = new SQLFactory(this, "删除数据媒体关联");
            sql.addParameter("siteid", siteid);
            sql.addParameter("linksid", linksid);
            sqllist.add(sql.getSQL());

            /*
             *插入操作记录
             */
            Rows rows = dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + siteid + "' and t1.linksid=" + linksid);
            for (Row row : rows) {
                sqllist.add(DataContrlLog.createLog(this, row.getString("ownertable"), row.getLong("ownerid"), "删除附件", "删除附件" + row.getString("document")).getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqllist);
        if (!sqllist.isEmpty()) {
            cleanAllDataPool();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "创建媒体数据下载记录", apiversion = R.ID10020701.v1.class)
    public String createdownlog() throws YosException {
        long linksid = content.getLongValue("linksid");
        long attachmentid = content.getLongValue("attachmentid");
        ArrayList<String> sqllist = new ArrayList<String>();
        SQLFactory sqlFactory = new SQLFactory(this, "创建媒体资源下载记录");
        sqlFactory.addParameter("sys_attachment_downlogid", createTableID("sys_attachment_downlog"));
        sqlFactory.addParameter("attachmentid", attachmentid);
        sqlFactory.addParameter("linksid", linksid);
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("createby", username);
        sqllist.add(sqlFactory.getSQL());

        /*
         *插入操作记录
         */
        Rows rows = dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + siteid + "' and t1.linksid=" + linksid);
        for (Row row : rows) {
            sqllist.add(DataContrlLog.createLog(this, row.getString("ownertable"), row.getLong("ownerid"), "下载附件", "下载附件" + row.getString("document")).getSQL());
        }

        dbConnect.runSqlUpdate(sqllist);
        return getSucReturnObject().toString();
    }

    @API(title = "媒体资源关联收藏", apiversion = R.ID10020801.v1.class)
    public String collectAttachmentLinks() throws YosException {
        String type = content.getString("type");//营销物料等
        long linksid = content.getLongValue("linksid");
        SQLFactory sqlFactory = new SQLFactory(this, "媒体数据收藏");
        sqlFactory.addParameter("sys_attachment_collectid", createTableID("sys_attachment_collect"));
        sqlFactory.addParameter("attachmentid", "null");
        sqlFactory.addParameter("linksid", linksid);
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("type", type);
        dbConnect.runSqlUpdate(sqlFactory);
        return getSucReturnObject().toString();
    }
}
