package restcontroller.sysmanage.develop.optiontype;

import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;

import java.util.ArrayList;
import java.util.Iterator;

import common.YosException;
import common.data.SQLFactory;
import restcontroller.R;

@API(title = "管理端-开发-选项分类")
public class optiontype extends Controller {

    public optiontype(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "选项类型查询", apiversion = R.ID10025101.v1.class)
    public String queryOption() throws YosException {
        Rows rows;
        if (content.containsKey("issql") && !content.getBooleanValue("issql")) {
            rows = dbConnect.runSqlQuery("select optiontypeid,typename,remarks,issystem,issql from sys_optiontype where issql=0 and issubvaluemag=0");
        } else {
            rows = dbConnect.runSqlQuery("select optiontypeid,typename,remarks,issystem,issql from sys_optiontype where issubvaluemag=0");
        }
        for (Row row : rows) {
            row.put("params", new JSONArray());
            if (row.getBoolean("issql")) {
                long optiontypeid = row.getLong("optiontypeid");
                Rows optiontypemxrows = dbConnect.runSqlQuery("select value,siteid from sys_optiontypemx where isused=1 and optiontypeid='" + optiontypeid + "' limit 0,1");
                for (Row optiontypemxrow : optiontypemxrows) {
                    String sql = optiontypemxrow.getString("value");
                    ArrayList<String> p = getSQLParams(sql);
                    p.remove("siteid");
                    row.put("params", p);
                }
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统选项分类选择查询", apiversion = R.ID10014701.v1.class)
    public String optiontypeselect() throws YosException {
        String typename = content.getString("typename");
        Rows optiontypeRows = dbConnect.runSqlQuery("select optiontypeid,issql,issubvaluemag from sys_optiontype where typename='" + typename + "'");
        if (optiontypeRows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到指定的选项分类").toString();
        }
        boolean issql = optiontypeRows.get(0).getBoolean("issql");
        long optiontypeid = optiontypeRows.get(0).getLong("optiontypeid");
        if (issql) {
            Rows optiontypemxrows = dbConnect.runSqlQuery("select value,siteid from sys_optiontypemx where isused=1 and (ifnull(siteid,'')='' or siteid='" + siteid + "') and optiontypeid='" + optiontypeid + "' limit 0,1");
            if (optiontypemxrows.isEmpty()) {
                return getErrReturnObject().setErrMsg("没有有效的选项分类查询").toString();
            } else {
                String sql = optiontypemxrows.get(0).getString("value");
                String psiteid = optiontypemxrows.get(0).getString("siteid");
                if (content.containsKey("parameter")) {
                    JSONObject parameterObject = content.getJSONObject("parameter");
                    Iterator<String> it = parameterObject.keySet().iterator();
                    while (it.hasNext()) {
                        String parameter = it.next();
                        String value = String.valueOf(parameterObject.get(parameter));
                        String sqlkey = "$" + parameter + "$";
                        if (value == null || "null".equalsIgnoreCase(value)) {
                            sql = sql.replace(sqlkey, "NULL");
                        } else {
                            sql = sql.replace(sqlkey, "'" + value + "'");
                        }
                    }
                    if (!psiteid.equals("") && !psiteid.equalsIgnoreCase("null")) {
                        /*
                         * 如果参数没有传递站点，且当前分类已经指定站点，则传入指定站点
                         */
                        sql = sql.replaceAll("(?i)\\u0024siteid\\u0024", "'" + psiteid + "'");
                    }
                }
                /*
                 * 如果以上条件还未消除站点信息，则将当前账号站点传入
                 */
                sql = sql.replaceAll("(?i)\\u0024siteid\\u0024", "'" + siteid + "'");
                sql = sql.replaceAll("(?i):sys_enterpriseid", "'" + sys_enterpriseid + "'");
                sql = sql.replaceAll("(?i):userid", "'" + userid + "'");
                sql = sql.replaceAll("(?i):hrid", "'" + hrid + "'");
                sql = sql.replaceAll("(?i):departmentid", "'" + departmentid + "'");
                sql = sql.replaceAll("(?i):siteid", "'" + siteid + "'");

                sql = sql.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                sql = sql + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;

                Rows rows = dbConnect.runSqlQuery(sql);
                return getSucReturnObject().setData(rows).toString();
            }
        } else {
            ArrayList<String> exceptvalues = new ArrayList<>();
            if (!content.containsKey("withroleoptionlimit") || content.getBooleanValue("withroleoptionlimit")) {
                QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_role_optionlimit", "value");
                querySQL.setWhere("optiontypeid", optiontypeid).setWhere("roleid", User.getUserRoleIDs(this, userid));
                exceptvalues = querySQL.query().toArrayList("value");
            }
            boolean issubvaluemag = optiontypeRows.get(0).getBoolean("issubvaluemag");
            JSONArray array = new JSONArray();
            Rows valuerows = dbConnect.runSqlQuery("select value,remarks,subvalues from sys_optiontypemx where isused=1 and (ifnull(siteid,'')='' or siteid='" + siteid + "') and optiontypeid='" + optiontypeid + "'");
            for (Row valuerow : valuerows) {
                if (!exceptvalues.contains(valuerow.getString("value"))) {
                    JSONObject object = new JSONObject();
                    object.put("value", valuerow.getString("value"));
                    object.put("remarks", valuerow.getString("remarks"));
                    if (issubvaluemag) {
                        try {
                            JSONArray subvaluesArray = valuerow.getJSONArray("subvalues");
                            object.put("subvalues", subvaluesArray);
                        } catch (Exception e) {
                            object.put("subvalues", new JSONArray());
                        }
                    }
                    array.add(object);
                }
            }
            return getSucReturnObject().setData(array).toString();
        }
    }
}
