package restcontroller.sysmanage.develop.datamag.administrativearea;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.InsertSQL;
import common.data.UpdateSQL;
import restcontroller.R;

/**
 * 行政区域管理
 */
public class administrativearea extends Controller {

    public administrativearea(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "省份查询", apiversion = R.ID10010501.v1.class)
    public String queryProvinces() throws YosException {
        Rows provinceRows = dbConnect.runSqlQuery("select * from t_province order by provinceid");
        return getSucReturnObject().setData(provinceRows).toString();
    }

    @API(title = "省份新增", apiversion = R.ID10010601.v1.class)
    public String insertOrModifyProvinces() throws YosException {
        long provinceid = content.getLong("provinceid");
        String provincenum = content.getString("provincenum");
        String province = content.getString("province");
        if (provinceid <= 0 || dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_province");
            insertSQL.setValue("provinceid", createTableID("t_province"));
            insertSQL.setValue("provincenum", provincenum);
            insertSQL.setValue("province", province);
            insertSQL.insert();
        } else {
            UpdateSQL rowupdate = SQLFactory.createUpdateSQL(this, "t_province");
            rowupdate.setValue("provincenum", provincenum);
            rowupdate.setValue("province", province);
            rowupdate.setWhere("provinceid", provinceid);
            rowupdate.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "省份删除", apiversion = R.ID10010701.v1.class)
    public String deleteProvinces() throws YosException {
        long provinceid = content.getLong("provinceid");
        dbConnect.runSqlUpdate("delete from t_province where provinceid=" + provinceid);
        return getSucReturnObject().toString();
    }


    @API(title = "城市查询", apiversion = R.ID10010801.v1.class)
    public String queryCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        Rows cityRows = dbConnect.runSqlQuery("select * from t_city where provinceid=" + provinceid + " order by cityid");
        return getSucReturnObject().setData(cityRows).toString();
    }

    @API(title = "城市新增", apiversion = R.ID10010901.v1.class)
    public String insertOrModifyCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        long cityid = content.getLong("cityid");
        String citynum = content.getString("citynum");
        String city = content.getString("city");

        if (dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的省份信息").toString();
        }
        if (cityid <= 0 || dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_city");
            insertSQL.setValue("cityid", createTableID("t_city"));
            insertSQL.setValue("provinceid", provinceid);
            insertSQL.setValue("citynum", citynum);
            insertSQL.setValue("city", city);
            insertSQL.insert();
        } else {
            UpdateSQL rowInsert = SQLFactory.createUpdateSQL(this, "t_city");
            rowInsert.setValue("citynum", citynum);
            rowInsert.setValue("city", city);
            rowInsert.setWhere("provinceid", provinceid);
            rowInsert.setWhere("cityid", cityid);
            rowInsert.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "城市删除", apiversion = R.ID10011001.v1.class)
    public String deleteCitys() throws YosException {
        long cityid = content.getLong("cityid");
        dbConnect.runSqlUpdate("delete from t_city where cityid=" + cityid);
        return getSucReturnObject().toString();
    }


    @API(title = "区县查询", apiversion = R.ID10011101.v1.class)
    public String queryCounties() throws YosException {
        long cityid = content.getLong("cityid");
        Rows countyRows = dbConnect.runSqlQuery("select * from t_county where cityid=" + cityid + " order by countyid");
        return getSucReturnObject().setData(countyRows).toString();
    }

    @API(title = "区县新增", apiversion = R.ID10011201.v1.class)
    public String insertOrModifyCounties() throws YosException {
        long cityid = content.getLong("cityid");
        long countyid = content.getLong("countyid");
        String countynum = content.getString("countynum");
        String county = content.getString("county");

        if (dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的城市信息").toString();
        }
        if (countyid <= 0 || dbConnect.runSqlQuery("select * from t_county where countyid=" + countyid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_county");
            insertSQL.setValue("countyid", createTableID("t_county"));
            insertSQL.setValue("cityid", cityid);
            insertSQL.setValue("countynum", countynum);
            insertSQL.setValue("county", county);
            insertSQL.insert();
        } else {
            UpdateSQL rowInsert = SQLFactory.createUpdateSQL(this, "t_county");
            rowInsert.setValue("countynum", countynum);
            rowInsert.setValue("county", county);
            rowInsert.setWhere("cityid", cityid);
            rowInsert.setWhere("countyid", countyid);
            rowInsert.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "区县删除", apiversion = R.ID10011301.v1.class)
    public String deleteCounties() throws YosException {
        long countyid = content.getLong("countyid");
        dbConnect.runSqlUpdate("delete from t_county where countyid=" + countyid);
        return getSucReturnObject().toString();
    }
}
