package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import common.data.db.DBConnect;
import restcontroller.R;

import java.util.ArrayList;
import java.util.HashMap;

@API(title = "管理端-开发-系统应用注册管理-表格管理")
public class appregistry_table extends Controller {

    public appregistry_table(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "应用表格查询", apiversion = R.ID10006101.v1.class)
    public String query_apptablelist() throws YosException {
        long systemappid = content.getLong("systemappid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_tables");
        querySQL.setWhere("systemappid", systemappid);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "应用表格新增修改", apiversion = R.ID10006201.v1.class)
    public String insertormodify_apptable() throws YosException {
        String table = content.getString("table");
        String tablename = content.getString("tablename");
        if (table.equals("") || !String.valueOf(table.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须以英文字母开头").toString();
        }
        if (!table.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须为英文字母或英文数字组合").toString();
        }
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            long systemappid = 0L;

            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用" + systemapp + "不存在").toString();
            }
            systemappid = sys_systemappRows.get(0).getLong("systemappid");

            long tableid = 0;
            Rows sys_systemapp_optionsRows = dbConnect.runSqlQuery("select*from sys_systemapp_tables where ifnull(siteids,'')='' and systemappid=" + systemappid + " and `table`='" + table + "'");

            if (sys_systemapp_optionsRows.isEmpty()) {
                tableid = createTableID("sys_systemapp_tables");
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tables");
                insertSQL.setValue("systemappid", systemappid);
                insertSQL.setValue("tableid", tableid);
                insertSQL.setValue("`table`", table);
                insertSQL.setValue("tablename", tablename);
                insertSQL.insert();
            } else {
                tableid = sys_systemapp_optionsRows.get(0).getLong("tableid");
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_tables");
                updateSQL.setValue("`table`", table);
                updateSQL.setValue("tablename", tablename);
                updateSQL.setWhere("tableid", tableid);
                updateSQL.update();
            }
            return getSucReturnObject().toString();
        } else {
            long systemappid = content.getLong("systemappid");
            long tableid = content.getLongValue("tableid");//新增时传0
            String siteids = content.getString("siteids");

            if (tableid <= 0 || dbConnect.runSqlQuery("select tableid from sys_systemapp_tables where tableid=" + tableid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tables where systemappid='" + systemappid + "' and siteids='" + siteids + "' and `table`='" + table + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格注册不可重复").toString();
                }
                tableid = createTableID("sys_systemapp_tables");
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tables");
                insertSQL.setValue("systemappid", systemappid);
                insertSQL.setValue("tableid", tableid);
                insertSQL.setValue("`table`", table);
                insertSQL.setValue("tablename", tablename);
                insertSQL.setValue("siteids", siteids);
                insertSQL.insert();
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tables where tableid!='" + tableid + "' and systemappid='" + systemappid + "' and siteids='" + siteids + "' and `table`='" + table + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格注册不可重复").toString();
                }
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_tables");
                updateSQL.setValue("`table`", table);
                updateSQL.setValue("tablename", tablename);
                updateSQL.setValue("siteids", siteids);
                updateSQL.setWhere("tableid", tableid);
                updateSQL.update();
            }
            return query_apptablelist();
        }
    }

    @API(title = "应用表格删除", apiversion = R.ID10006301.v1.class)
    public String delete_apptable() throws YosException {
        long tableid = content.getLong("tableid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_tablecols_site where tablecolid in (select tablecolid from sys_systemapp_tablecols where tableid=" + tableid + ")");
        list.add("delete from sys_systemapp_tables where tableid=" + tableid);
        list.add("delete from sys_systemapp_tablecols where tableid=" + tableid);

        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "应用表格栏位查询", apiversion = R.ID10006401.v1.class)
    public String query_apptablecollist() throws YosException {
        long tableid = content.getLong("tableid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_tablecols");
        querySQL.setWhere("tableid", tableid);
        querySQL.setOrderBy("case when freezetype = 'left' then 1 when freezetype = 'right' then 3 else 2 end,sequence");
        Rows rows = querySQL.query();
        for (Row row : rows) {
            JSONObject dataformat = row.getJSONObject("dataformat");
            if (!dataformat.containsKey("type")) {
                dataformat.put("type", "");
            }
            if (!dataformat.containsKey("mapping")) {
                dataformat.put("mapping", new JSONArray());
            }
            if (!dataformat.containsKey("option_typename")) {
                dataformat.put("option_typename", "");
            }
            row.put("dataformat", dataformat);
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "站点应用表格栏位查询", apiversion = R.ID10006501.v1.class)
    public String query_siteapptablecollist() throws YosException {
        long tableid = content.getLong("tableid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_tablecols");
        querySQL.setWhere("tableid", tableid);
        querySQL.setOrderBy("case when freezetype = 'left' then 1 when freezetype = 'right' then 3 else 2 end,sequence");
        Rows rows = querySQL.query();

        JSONArray array = new JSONArray();

        Rows siteRows = dbConnect.runSqlQuery("select siteid,sitename from sys_site order by siteuid");
        RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select t1.siteid,t1.tablecolid,t1.title,t1.width,t1.hidden,t1.sortable from sys_systemapp_tablecols_site t1 inner join sys_systemapp_tablecols t2 on t1.tablecolid=t2.tablecolid and t2.tableid=" + tableid).toRowsMap("siteid");
        for (Row siteRow : siteRows) {
            String siteid = siteRow.getString("siteid");
            String sitename = siteRow.getString("sitename");

            JSONObject object = new JSONObject();
            object.put("siteid", siteid);
            object.put("sitename", sitename);

            JSONArray sitecolarray = new JSONArray();
            RowsMap map = sitetablecolRowsMap.get(siteid).toRowsMap("tablecolid");
            for (Row colrow : rows) {
                JSONObject sitecolObject = new JSONObject();
                long tablecolid = colrow.getLong("tablecolid");
                sitecolObject.put("tablecolid", tablecolid);
                sitecolObject.put("title_default", colrow.getString("title"));
                sitecolObject.put("align", colrow.getString("align"));
                sitecolObject.put("script", colrow.getString("script"));
                sitecolObject.put("freezetype", colrow.getString("freezetype"));

                if (map.containsKey(String.valueOf(tablecolid))) {
                    Row r = map.get(String.valueOf(tablecolid)).get(0);
                    sitecolObject.put("title", r.getString("title").equals("") ? colrow.getString("title") : r.getString("title"));
                    sitecolObject.put("width", r.getInteger("width") == 0 ? colrow.getInteger("width") : r.getInteger("width"));
                    sitecolObject.put("sequence", r.getInteger("sequence") == 0 ? colrow.getInteger("sequence") : r.getInteger("sequence"));
                    sitecolObject.put("filter", r.getInteger("filter"));
                    sitecolObject.put("hidden", r.getInteger("hidden") == 0 ? colrow.getInteger("hidden") : 1);
                    sitecolObject.put("sortable", r.getInteger("sortable") == 0 ? colrow.getInteger("sortable") : 1);
                    sitecolObject.put("customed", 1);
                } else {
                    sitecolObject.put("title", colrow.getString("title"));
                    sitecolObject.put("width", colrow.getInteger("width"));
                    sitecolObject.put("sequence", colrow.getInteger("sequence"));
                    sitecolObject.put("filter", colrow.getInteger("filter"));
                    sitecolObject.put("hidden", colrow.getInteger("hidden"));
                    sitecolObject.put("sortable", colrow.getInteger("sortable"));
                    sitecolObject.put("customed", 0);
                }
                sitecolarray.add(sitecolObject);
            }
            object.put("list", sitecolarray);
            array.add(object);
        }
        return getSucReturnObject().setData(array).toString();
    }

    @API(title = "应用表格栏位新增修改", apiversion = R.ID10006601.v1.class)
    public String insertormodify_apptablecol() throws YosException {
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            String table = content.getString("table");
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int width = content.getInteger("width");
            int filter = content.getIntValue("filter");
            int hidden = content.getIntValue("hidden");
            int sortable = content.getIntValue("sortable");
            String align = content.getStringValue("align");
            String script = content.getStringValue("script", true);
            String freezetype = content.getStringValue("freezetype");
            int sequence = content.getIntValue("sequence");
            JSONObject dataformatObject = new JSONObject();
            if (content.containsKey("dataformat")) {
                dataformatObject = content.getJSONObject("dataformat");
            }

            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("系统应用" + systemapp + "不存在").toString();
            }
            long systemappid = sys_systemappRows.get(0).getLong("systemappid");

            Rows sys_systemapp_tablesRows = dbConnect.runSqlQuery("select * from sys_systemapp_tables where systemappid='" + systemappid + "' and `table`='" + table + "' ");
            if (sys_systemapp_tablesRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用表" + table + "不存在").toString();
            }
            long tableid = sys_systemapp_tablesRows.get(0).getLong("tableid");

            Rows sys_systemapp_tablecolsRows = dbConnect.runSqlQuery("select * from sys_systemapp_tablecols where tableid=" + tableid + " and columnname='" + columnname + "'");

            long tablecolid = 0L;
            if (sys_systemapp_tablecolsRows.isEmpty()) {
                tablecolid = createTableID("sys_systemapp_tablecols");
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tablecols");
                insertSQL.setValue("tableid", tableid);
                insertSQL.setValue("tablecolid", tablecolid);
                insertSQL.setValue("columnname", columnname);
                insertSQL.setValue("title", title);
                insertSQL.setValue("width", width);
                insertSQL.setValue("filter", filter);
                insertSQL.setValue("hidden", hidden);
                insertSQL.setValue("sortable", sortable);
                if (sequence > 0) {
                    insertSQL.setValue("sequence", sequence);
                }
                insertSQL.setValue("align", align);
                insertSQL.setValue("script", script);
                insertSQL.setValue("freezetype", freezetype);
                insertSQL.setValue("dataformat", dataformatObject);
                insertSQL.insert();
            } else {
                tablecolid = sys_systemapp_tablecolsRows.get(0).getLong("tablecolid");
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_tablecols");
                updateSQL.setValue("columnname", columnname);
                updateSQL.setValue("title", title);
                updateSQL.setValue("width", width);
                updateSQL.setValue("filter", filter);
                updateSQL.setValue("hidden", hidden);
                updateSQL.setValue("sortable", sortable);
                if (sequence > 0) {
                    updateSQL.setValue("sequence", sequence);
                }
                updateSQL.setValue("align", align);
                updateSQL.setValue("script", script);
                updateSQL.setValue("freezetype", freezetype);
                updateSQL.setWhere("tablecolid", tablecolid);
                updateSQL.setValue("dataformat", dataformatObject);
                updateSQL.update();
                TableColFilterMap.clear();
                TableColSortableMap.clear();
                TableColMappingMap.clear();
            }
            return getSucReturnObject().toString();
        } else {
            long tableid = content.getLong("tableid");
            long tablecolid = content.getLongValue("tablecolid");//新增时传0
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int width = content.getIntValue("width");
            int filter = content.getIntValue("filter");
            int hidden = content.getIntValue("hidden");
            int sortable = content.getIntValue("sortable");
            String align = content.getStringValue("align");
            String script = content.getStringValue("script", true);
            String freezetype = content.getStringValue("freezetype");
            JSONObject dataformatObject = content.getJSONObject("dataformat");

            if (dataformatObject.getStringValue("type").equals("mapping")) {
                dataformatObject.put("option_typename", "");
            } else if (dataformatObject.getStringValue("type").equals("option")) {
                dataformatObject.put("mapping", new JSONArray());
            } else {
                dataformatObject.put("option_typename", "");
                dataformatObject.put("mapping", new JSONArray());
            }

            if (tablecolid <= 0 || dbConnect.runSqlQuery("select tablecolid from sys_systemapp_tablecols where tablecolid=" + tablecolid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols where tableid='" + tableid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格栏位不可重复").toString();
                }
                tablecolid = createTableID("sys_systemapp_tablecols");
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tablecols");
                insertSQL.setValue("tableid", tableid);
                insertSQL.setValue("tablecolid", tablecolid);
                insertSQL.setValue("columnname", columnname);
                insertSQL.setValue("title", title);
                insertSQL.setValue("width", width);
                insertSQL.setValue("filter", filter);
                insertSQL.setValue("hidden", hidden);
                insertSQL.setValue("sortable", sortable);
                insertSQL.setValue("sequence", 1);
                insertSQL.setValue("align", align);
                insertSQL.setValue("script", script);
                insertSQL.setValue("freezetype", freezetype);
                insertSQL.setValue("dataformat", dataformatObject);
                insertSQL.insert();
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols where tablecolid!='" + tablecolid + "' and tableid='" + tableid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格栏位不可重复").toString();
                }
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_tablecols");
                updateSQL.setValue("columnname", columnname);
                updateSQL.setValue("title", title);
                updateSQL.setValue("width", width);
                updateSQL.setValue("filter", filter);
                updateSQL.setValue("hidden", hidden);
                updateSQL.setValue("sortable", sortable);
                updateSQL.setValue("align", align);
                updateSQL.setValue("script", script);
                updateSQL.setValue("freezetype", freezetype);
                updateSQL.setWhere("tablecolid", tablecolid);
                updateSQL.setValue("dataformat", dataformatObject);
                updateSQL.update();
                TableColFilterMap.clear();
                TableColSortableMap.clear();
                TableColMappingMap.clear();
            }
            return query_apptablecollist();
        }
    }

    @API(title = "站点应用表格栏位新增修改", apiversion = R.ID10006701.v1.class)
    public String modify_apptablecol_site() throws YosException {
        long tablecolid = content.getLong("tablecolid");
        String siteid = content.getString("siteid");
        String title = content.getString("title");
        int width = content.getInteger("width");
        int hidden = content.getIntValue("hidden");
        int filter = content.getIntValue("filter");
        int sortable = content.getIntValue("sortable");

        Rows sys_systemapp_tablecolRows = dbConnect.runSqlQuery("select * from sys_systemapp_tablecols where tablecolid=" + tablecolid);
        if (sys_systemapp_tablecolRows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到该表格栏位").toString();
        }

        String title_default = sys_systemapp_tablecolRows.get(0).getString("title");
        int width_default = sys_systemapp_tablecolRows.get(0).getInteger("width");
        int hidden_default = sys_systemapp_tablecolRows.get(0).getInteger("hidden");

        if ((title.trim().equals("") || title.equals(title_default)) && (width == 0 || width == width_default) && (hidden == 0 || hidden == hidden_default)) {
            dbConnect.runSqlUpdate("delete from sys_systemapp_tablecols_site where siteid='" + siteid + "' and tablecolid=" + tablecolid);
            return getSucReturnObject().toString();
        }

        title = title.equals(title_default) ? "" : title;
        width = width == width_default ? 0 : width;
        hidden = hidden == hidden_default ? 0 : hidden;
        if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols_site where siteid='" + siteid + "'and tablecolid=" + tablecolid).isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "站点应用表格栏位新增");
            sqlFactory.addParameter("sys_systemapp_tablecols_siteid", createTableID("sys_systemapp_tablecols_site"));
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("tablecolid", tablecolid);
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("width", width);
            sqlFactory.addParameter("hidden", hidden);
            sqlFactory.addParameter("sortable", sortable);
            sqlFactory.addParameter("filter", filter);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            dbConnect.runSqlUpdate("update sys_systemapp_tablecols_site set title='" + title + "',width=" + width + ",hidden=" + hidden + ",sortable=" + sortable + ",filter=" + filter + " where siteid='" + siteid + "' and tablecolid=" + tablecolid);
            TableColFilterMap.clear();
            TableColSortableMap.clear();
            TableColMappingMap.clear();
        }
        return getSucReturnObject().toString();
    }


    @API(title = "应用表格栏位删除", apiversion = R.ID10006801.v1.class)
    public String delete_apptablecol() throws YosException {
        long tablecolid = content.getLong("tablecolid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_tablecols where tablecolid=" + tablecolid);
        list.add("delete from sys_systemapp_tablecols_site where tablecolid=" + tablecolid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "应用表格选择")
    public String querytable() throws YosException {
        long systemappid = content.getLong("systemappid");
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.`table` like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.tablename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.tableid ='").append(whereObject.getString("condition")).append("' ");
                where.append("or t2.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }

        SQLFactory sqlFactory = new SQLFactory(this, "应用表格选择查询");
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "应用表格复制", apiversion = R.ID10006901.v1.class)
    public String duplicatetable() throws YosException {
        long systemappid = content.getLong("systemappid");
        long tableid = content.getLong("tableid");

        ArrayList<String> sqlList = new ArrayList<>();

        Rows tablerows = dbConnect.runSqlQuery("select `table`,tablename from sys_systemapp_tables where tableid=" + tableid);
        for (Row tablerow : tablerows) {
            long newtableid = createTableID("sys_systemapp_tables");

            InsertSQL table_insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tables");
            table_insertSQL.setValue("systemappid", systemappid);
            table_insertSQL.setValue("tableid", newtableid);
            table_insertSQL.setValue("`table`", tablerow.getString("table"));
            table_insertSQL.setValue("tablename", tablerow.getString("tablename"));
            sqlList.add(table_insertSQL.getSQL());

            Rows tablecolrows = dbConnect.runSqlQuery("select columnname,title,width,filter,sequence,hidden,sortable,align,script,freezetype from sys_systemapp_tablecols where tableid=" + tableid);
            for (Row tablecolrow : tablecolrows) {

                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_tablecols");
                insertSQL.setValue("tableid", newtableid);
                insertSQL.setValue("tablecolid", createTableID("sys_systemapp_tablecols"));
                insertSQL.setValue("columnname", tablecolrow.getString("columnname"));
                insertSQL.setValue("title", tablecolrow.getString("title"));
                insertSQL.setValue("width", tablecolrow.getInteger("width"));
                insertSQL.setValue("filter", tablecolrow.getInteger("filter"));
                insertSQL.setValue("hidden", tablecolrow.getInteger("hidden"));
                insertSQL.setValue("sortable", tablecolrow.getInteger("sortable"));
                insertSQL.setValue("sequence", tablecolrow.getInteger("sequence"));
                insertSQL.setValue("align", tablecolrow.getString("align"));
                insertSQL.setValue("script", tablecolrow.getString("script"));
                insertSQL.setValue("freezetype", tablecolrow.getString("freezetype"));
                insertSQL.setValue("dataformat", tablecolrow.getJSONObject("dataformat"));
                sqlList.add(insertSQL.getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqlList);
        return getSucReturnObject().toString();
    }

    private static HashMap<String, Integer> TableColFilterMap = new HashMap<>();
    private static HashMap<String, Boolean> TableColSortableMap = new HashMap<>();
    private static HashMap<String, String> TableColMappingMap = new HashMap<>();

    /**
     * 获取表格栏位过滤方式，0 不过滤，1 精确搜索 2 模糊搜索
     *
     * @param controller
     * @param tableid
     * @param columnname
     * @return
     */
    public static int getTableColFilter(Controller controller, long tableid, String columnname) throws YosException {
        String key = controller.siteid + tableid + columnname;
        if (TableColFilterMap.containsKey(key)) {
            return TableColFilterMap.get(key);
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_systemapp_tablecols", "filter");
        querySQL.addJoinTable(JOINTYPE.left, "sys_systemapp_tablecols_site", "sys_systemapp_tablecols_site", "tablecolid=:tablecolid and siteid='" + controller.siteid + "'");
        querySQL.addQueryFields("filter_site", "ifnull(sys_systemapp_tablecols_site.filter,-1)");
        querySQL.setWhere("tableid", tableid).setWhere("columnname", columnname);
        Rows rows = querySQL.query();
        if (rows.isEmpty()) {
            return 0;
        }
        int filter = rows.get(0).getInteger("filter_site") >= 0 ? rows.get(0).getInteger("filter_site") : rows.get(0).getInteger("filter");
        TableColFilterMap.put(key, filter);
        return filter;
    }


    /**
     * 获取表格栏位排序方式
     *
     * @param controller
     * @param tableid
     * @param columnname
     * @return
     */
    public static boolean getTableColSortable(Controller controller, long tableid, String columnname) throws YosException {
        String key = controller.siteid + tableid + columnname;
        if (TableColSortableMap.containsKey(key)) {
            return TableColSortableMap.get(key);
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_systemapp_tablecols", "sortable");
        querySQL.addJoinTable(JOINTYPE.left, "sys_systemapp_tablecols_site", "sys_systemapp_tablecols_site", "tablecolid=:tablecolid and siteid='" + controller.siteid + "'");
        querySQL.addQueryFields("sortable_site", "ifnull(sys_systemapp_tablecols_site.sortable,-1)");
        querySQL.setWhere("tableid", tableid).setWhere("columnname", columnname);
        Rows rows = querySQL.query();
        if (rows.isEmpty()) {
            return false;
        }
        boolean sortable = rows.get(0).getInteger("sortable_site") >= 0 ? rows.get(0).getBoolean("sortable_site") : rows.get(0).getBoolean("sortable");
        TableColSortableMap.put(key, sortable);
        return sortable;
    }

    public static String getTableColMapping(Controller controller, long tableid, String columnname, String value) throws YosException {
        value = value.trim();
        if (value.equals("")) {
            return value;
        }
        String key = tableid + columnname + "_" + value;
        if (TableColMappingMap.containsKey(key)) {
            return TableColMappingMap.get(key);
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_systemapp_tablecols", "dataformat");
        querySQL.setWhere("tableid", tableid).setWhere("columnname", columnname);
        Rows rows = querySQL.query();
        for (Row row : rows) {
            JSONObject dataformatObject = row.getJSONObject("dataformat");
            String type = dataformatObject.getString("type");
            if (type.equals("mapping")) {
                JSONArray mappingArray = dataformatObject.getJSONArray("mapping");
                for (Object o : mappingArray) {
                    JSONObject mappingObject = (JSONObject) o;
                    if (mappingObject.getStringValue("value").equals(value)) {
                        return value;
                    }
                    if (mappingObject.getStringValue("label").equals(value)) {
                        TableColMappingMap.put(key, mappingObject.getStringValue("value"));
                        return TableColMappingMap.get(key);
                    }
                }
            } else if (type.equals("option")) {
                String option_typename = dataformatObject.getString("option_typename");
                Rows optionRows = controller.dbConnect.runSqlQuery("select t2.value,t2.remarks from sys_optiontype t1\n" +
                        "inner join sys_optiontypemx t2 on t1.optiontypeid=t2.optiontypeid\n" +
                        "where t1.typename='" + option_typename + "' and (ifnull(t2.siteid,'')='' or t2.siteid='" + controller.siteid + "')");
                for (Row optionRow : optionRows) {
                    if (optionRow.getString("value").equals(value)) {
                        return value;
                    }
                    if (optionRow.getString("remarks").equals(value)) {
                        TableColMappingMap.put(key, optionRow.getString("value"));
                        return TableColMappingMap.get(key);
                    }
                }
            }
        }
        return value;
    }
}
