package common.parameter;

import beans.parameter.Parameter;
import com.mchange.v2.util.PropertiesUtils;

import java.io.InputStream;
import java.util.Properties;

public class properties {
    protected static Properties yosProperties;

    public static Properties getYosProperties() {
        if (yosProperties == null || yosProperties.isEmpty()) {
            yosProperties = new Properties();
            try {
                InputStream in = PropertiesUtils.class.getClassLoader().getResourceAsStream("yos.properties");
                assert in != null;
                yosProperties.load(in);
                in.close();
                License.get();
            } catch (Exception e) {
                e.printStackTrace();
                yosProperties = null;
            } finally {
                if (yosProperties != null && yosProperties.isEmpty()) {
                    yosProperties = null;
                }
            }
        }
        return yosProperties;
    }

    /**
     * log4j日志参数设置
     *
     * @return
     */
    private static Properties log4jProperties = new Properties();

    public static Properties getLog4jProperties() {
        if (log4jProperties == null || log4jProperties.isEmpty()) {
            log4jProperties = new Properties();
            InputStream in = PropertiesUtils.class.getClassLoader().getResourceAsStream("log4j.properties");
            try {
                log4jProperties.load(in);
            } catch (Exception e) {
                e.printStackTrace();
                log4jProperties = null;
            } finally {
                if (log4jProperties != null && log4jProperties.isEmpty()) {
                    log4jProperties = null;
                }
            }
        }
        try {
            if (Parameter.get("system_runmode_debug").equalsIgnoreCase("true")) {
                log4jProperties.setProperty("log4j.rootLogger", "DEBUG,CONSOLE, FILE");
            } else {
                log4jProperties.setProperty("log4j.rootLogger", "INFO,CONSOLE, FILE");
            }
            log4jProperties.setProperty("log4j.appender.CONSOLE", "org.apache.log4j.ConsoleAppender");
            log4jProperties.setProperty("log4j.appender.CONSOLE.layout", "org.apache.log4j.PatternLayout");
            log4jProperties.setProperty("log4j.appender.CONSOLE.layout.ConversionPattern", "%d{HH:mm:ss:SSS MMMdd} %-2p  [%c] %m%n");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return log4jProperties;
    }
}
