package common.parameter;

import com.alibaba.fastjson.JSONObject;
import common.YosLogger;
import utility.tools.Encryption;
import utility.tools.MessageMonitoringStation;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;

public class License implements YosLogger {
    private String customer;
    private String licenseType;
    private int maxDBConCount = 50;
    private String macAddress;
    private Date expiresDate;

    public String getCustomer() {
        return customer;
    }

    public String getLicenseType() {
        return licenseType;
    }

    public int getMaxDBConCount() {
        if (maxDBConCount <= 0 || maxDBConCount > 100) {
            return 50;
        }
        return maxDBConCount;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public Date getExpiresDate() {
        return expiresDate;
    }

    /**
     * 获取授权剩余天数
     *
     * @return
     */
    public long getVerifyDays() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(license.getExpiresDate());
        LocalDate enddate = LocalDate.of(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH) + 1, calendar.get(Calendar.DATE));
        return ChronoUnit.DAYS.between(LocalDate.now(), enddate);
    }

    private void setCustomer(String customer) {
        this.customer = customer;
        logger.info("授权对象:" + customer);
    }

    private void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
        logger.info("证书类型:" + licenseType);
    }

    private void setMaxDBConCount(int maxDBConCount) {
        this.maxDBConCount = maxDBConCount;
        logger.info("数据库最大连接数:" + maxDBConCount);
    }

    private void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
        logger.info("物理地址:" + macAddress);
    }

    private void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
        logger.info("授权截止日期:" + new SimpleDateFormat("yyyy-MM-dd").format(expiresDate));
    }


    private static JSONObject licenseDataObject = new JSONObject();

    private static int day = 0;
    private static License license = new License();

    public static License get() {
        if (day != (day = Calendar.getInstance().get(Calendar.DATE)) && System.getProperty("catalina.home") != null) {
            logger.info("===========授权许可证书校验===========");
            try {
                InputStream inputStream = new FileInputStream(System.getProperty("catalina.home") + "/webapps/yos.license");
                byte[] buffer = new byte[1024];
                int bytesRead;
                StringBuilder license_str = new StringBuilder();
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    license_str.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
                inputStream.close();
                if (verifyLicense(license_str.toString())) {
                    license.setCustomer(Encryption.Decode_Base64(licenseDataObject.getString("customer"), "utf-8"));
                    license.setLicenseType(licenseDataObject.getString("licenseType"));
                    license.setMaxDBConCount(licenseDataObject.getIntValue("maxDBConCount"));
                    license.setMacAddress(licenseDataObject.getString("macAddress"));
                    if (!licenseDataObject.getStringValue("macAddress").equals("")) {
                        byte[] macAddress = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
                        StringBuilder sb1 = new StringBuilder();
                        for (int i = 0; i < macAddress.length; i++) {
                            sb1.append(String.format("%02X%s", macAddress[i], (i < macAddress.length - 1) ? "-" : ""));
                        }
                        if (!(licenseDataObject.getStringValue("macAddress").replace(":", "").replace("-", "").equalsIgnoreCase(sb1.toString().replace("-", "")))) {
                            logger.error("===========MAC地址" + sb1 + "无效！===========");
                            System.exit(0);
                        }
                    }
                    Date expiresDate = new SimpleDateFormat("yyyyMMdd").parse(licenseDataObject.getString("expiresDate"));
                    license.setExpiresDate(expiresDate);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(expiresDate);
                    calendar.add(Calendar.DATE, 1);
                    if (Calendar.getInstance().getTime().before(calendar.getTime())) {
                        logger.info("===========授权证书验证通过！===========");
                        try {
                            if (license.getVerifyDays() < 15) {
                                MessageMonitoringStation.send("《" + license.getCustomer() + "》授权证书即将于" + new SimpleDateFormat("yyyy-MM-dd").format(license.getExpiresDate()) + "日到期！");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        logger.error("===========授权证书已过期！===========");
                        System.exit(0);
                    }
                } else {
                    logger.error("===========授权证书无效！===========");
                    System.exit(0);
                }
            } catch (Exception e) {
                logger.error("===========授权证书验证失败！===========");
                System.exit(0);
                e.printStackTrace();
            }
        }
        return license;
    }

    /**
     * 证书验证
     *
     * @param licenseData
     * @throws Exception
     */
    private static boolean verifyLicense(String licenseData) throws Exception {
        licenseData = new String(decodeHex(licenseData), StandardCharsets.UTF_8);
        String data = licenseData.substring(0, licenseData.indexOf(headkey));
        data = new String(decodeHex(data), StandardCharsets.UTF_8);
        try {
            licenseDataObject = JSONObject.parseObject(data);
        } catch (Exception e) {
            return false;
        }
        String signature = licenseData.substring(licenseData.indexOf(headkey) + headkey.length());
        byte[] publicKey_byte = decodeHex(publicKey_str);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKey_byte);
        PublicKey publicKey = KeyFactory.getInstance("DSA").generatePublic(publicKeySpec);
        // 验证签名
        Signature verification = Signature.getInstance("DSA");
        verification.initVerify(publicKey);

        verification.update(data.getBytes());
        return verification.verify(decodeHex(signature));
    }

    static String publicKey_str = "MIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAT3/ly1i2dCCahHFdxx+v21eg0Y1gnhU2m0CCmvlG15pCTJG7r3BQPNG9wzY2g5JtzhvIZ58PNsuqtMkXYtZJYiCrP77scgFF9uedwc+dtKHvCQLMQhIuIN75q/WMpXpXvwl8Po21Ja+8Wu/gNMa2SEAGmXVR6yVOmM9lTrQOjBI=";

    public static byte[] decodeHex(String hexString) {
        return Base64.getDecoder().decode(hexString.getBytes(StandardCharsets.UTF_8));
    }

    public static String headkey = "V1c5elRHbGpaVzV6WlElM0QlM0Q=";
}
