package restcontroller.system.im.imdialog;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.parameter.parameter;
import utility.tools.Encryption;

import java.util.ArrayList;
import java.util.Calendar;

import common.Controller;
import common.YosException;

public class imdialog extends Controller {

    /**
     * 构造函数
     *
     * @param content
     */
    public imdialog(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 群对话框列表查询
     *
     * @return
     */
    public String query_imdialogList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.fimdialogname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("fimdialogtype") && !"".equals(whereObject.getString("fimdialogtype"))) {
                where.append(" and(");
                where.append("t1.fimdialogtype ='").append(whereObject.getString("fimdialogtype")).append("' ");
                where.append(")");
            }
            //fimdialogtype2：不等于这个类型的
            if (whereObject.containsKey("fimdialogtype2") && !"".equals(whereObject.getString("fimdialogtype2"))) {
                where.append(" and(");
                where.append("t1.fimdialogtype !='").append(whereObject.getString("fimdialogtype2")).append("' ");
                where.append(")");
            }
        }
        SQLFactory timdialogSQL = new SQLFactory(this, "即时通讯普通群列表查询");
        timdialogSQL.addParameter("siteid", siteid);
        timdialogSQL.addParameter("userid", userid);
        timdialogSQL.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(timdialogSQL.getSQL());

        SQLFactory timdialoguserSQL = new SQLFactory(this, "即时通讯群成员列表查询");
        timdialoguserSQL.addParameter("siteid", siteid);
        timdialoguserSQL.addParameter_in("timdialogid", rows.toArrayList("timdialogid"));
        RowsMap timdialoguserRowsMap = dbConnect.runSqlQuery(timdialoguserSQL.getSQL()).toRowsMap("timdialogid");

        SQLFactory timnewmsgSQL = new SQLFactory(this, "即时通讯普通群最新消息查询");
        timnewmsgSQL.addParameter("siteid", siteid);
        timnewmsgSQL.addParameter_in("timdialogid", rows.toArrayList("timdialogid"));
        RowsMap newmsgmap = timnewmsgSQL.runSqlQuery(dbConnect).toRowsMap("timdialogid");
        for (Row row : rows) {
            Rows newmsgrows = newmsgmap.get(row.getString("timdialogid"));
            for (Row newmsg : newmsgrows) {
                newmsg.put("websocketcontroller/message", JSONObject.parseObject(newmsg.getString("websocketcontroller/message")));
                newmsg.put("fisonline", parameter.websocketClients.containsKey(newmsg.getLong("userid")) ? 1 : 0);
            }
            row.put("latestnews", newmsgrows);//最新消息

            Rows timdialoguserRows = timdialoguserRowsMap.get(row.getString("timdialogid"));
            for (Row user : timdialoguserRows) {
                user.put("headportraiturl", getHeadPic(user.getLong("userid")));
            }
            row.put("users", timdialoguserRows);//群成员头像
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 群主界面查询
     *
     * @return
     */
    public String query_imdialogMain() throws YosException {
        long timdialogid = content.getLong("timdialogid");
        SQLFactory timdialogSQL = new SQLFactory(this, "即时通讯群主界面查询");
        timdialogSQL.addParameter("siteid", siteid);
        timdialogSQL.addParameter("userid", userid);
        timdialogSQL.addParameter("timdialogid", timdialogid);

        Rows rows = dbConnect.runSqlQuery(timdialogSQL.getSQL());
        for (Row row : rows) {
            SQLFactory timdialoguserSQL = new SQLFactory(this, "即时通讯群成员列表查询");
            timdialoguserSQL.addParameter("siteid", siteid);
            timdialoguserSQL.addParameter_in("timdialogid", content.getString("timdialogid"));
            Rows userrows = dbConnect.runSqlQuery(timdialoguserSQL.getSQL());

            int onlinecount = 0;
            for (Row user : userrows) {
                boolean isonline = parameter.websocketClients.containsKey(user.getLong("userid"));
                if (isonline) {
                    user.put("fisonline", 1);
                    onlinecount = onlinecount + 1;
                } else {
                    user.put("fisonline", 0);
                }
                user.put("headportraiturl", getHeadPic(user.getLong("userid")));
            }
            row.put("users", userrows);
            row.put("usertotalcount", userrows.size());
            row.put("useronlinecount", onlinecount);
        }
        if (content.containsKey("websocketcontroller/message")) {
            //初始聊天记录，话题
            JSONObject messageObject = content.getJSONObject("websocketcontroller/message");
            long messageuserid = messageObject.getJSONObject("sendfrom").getLong("userid");
            messageObject.put("timdialogid", timdialogid);
            messageObject.put("fdatetime", getDateTime_Str());
            messageObject.put("fmessageid", new Encryption().Encode_MD5(siteid + messageuserid + Calendar.getInstance().getTimeInMillis()));

            SQLFactory sqlFactory = new SQLFactory(this, "即时通讯群消息插入");
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("fnotes", "话题回复");
            sqlFactory.addParameter("timdialogid", timdialogid);
            sqlFactory.addParameter("userid", messageuserid);
            sqlFactory.addParameter("fmessageobj", messageObject.toJSONString());
            sqlFactory.addParameter("fmessageid", messageObject.getString("messageid"));
            sqlFactory.addParameter("fmessagetype", messageObject.getString("ftype"));

            if ("data".equals(messageObject.getString("ftype"))) {
                sqlFactory.addParameter("ownerid", messageObject.getJSONObject("data").getString("ownerid"));
                sqlFactory.addParameter("ownertable", messageObject.getJSONObject("data").getString("ownertable"));
            } else {
                sqlFactory.addParameter("ownerid", "null");
                sqlFactory.addParameter("ownertable", "null");
            }
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 一键联系
     *
     * @return
     */
    public String quickcontact() throws Exception {
        long buserid = content.getLongValue("userid");//根据对方userid，查一对一聊天对话框
        SQLFactory factory = new SQLFactory(this, "根据用户ID查询一对一聊天对话框ID");
        factory.addParameter("siteid", siteid);
        factory.addParameter_in("userid", new String[]{String.valueOf(userid), String.valueOf(buserid)});
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        if (!rows.isEmpty()) {
            content.put("timdialogid", rows.get(0).getLong("timdialogid"));
            return query_imdialogMain();
        } else {
            JSONArray usersArray = new JSONArray();
            usersArray.add(String.valueOf(userid));
            usersArray.add(String.valueOf(buserid));
            content.put("fimdialogname", username + "-" + getUser(buserid).getString("fname"));
            content.put("fimdialogtype", "普通");
            content.put("users", usersArray);
            return insertOrModify();
        }
    }


    /**
     * 群消息查询
     *
     * @return
     */
    public String query_imdialogMessage() throws YosException {
        long timdialogid = content.getLong("timdialogid");
        /**
         *排序条件设置
         */
        //String[] sortfield = {"t1.timdialogmessageid desc"};
        //String sort = getSort(sortfield, "t1.timdialogmessageid desc");

        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.fnotes like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("begdate") && !"".equals(whereObject.getString("begdate"))) {
                where.append(" and convert(varchar(10),t1.createdate,120)>=").append("'").append(whereObject.getString("begdate")).append("'");
            }
            if (whereObject.containsKey("enddate") && !"".equals(whereObject.getString("enddate"))) {
                where.append(" and convert(varchar(10),t1.createdate,120)<=").append("'").append(whereObject.getString("enddate")).append("'");
            }
        }

        SQLFactory timdialogSQL = new SQLFactory(this, "即时通讯群历史消息查询", pageSize, pageNumber, pageSorting);
        timdialogSQL.addParameter("siteid", siteid);
        timdialogSQL.addParameter("timdialogid", timdialogid);
        timdialogSQL.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(timdialogSQL.getSQL());
        for (Row row : rows) {
            String message = row.getString("websocketcontroller/message");
            row.put("websocketcontroller/message", JSONObject.parseObject(message));
        }
        //清除未读消息数
        dbConnect.runSqlUpdate("update timdialogusers set funreadmsgcount=0 where siteid='" + siteid + "' and timdialogid='" + timdialogid + "' and userid='" + userid + "'");
        return getSucReturnObject().setData(rows).toString();
    }

    public String restUnReadMsgCount() throws YosException {
        long timdialogid = content.getLong("timdialogid");
        dbConnect.runSqlUpdate("update timdialogusers set funreadmsgcount=0 where siteid='" + siteid + "' and timdialogid='" + timdialogid + "' and userid='" + userid + "'");
        return getSucReturnObject().toString();
    }


    /**
     * 新建聊天对话框
     *
     * @return
     */
    public String insertOrModify() throws Exception {
        long timdialogid = content.getLongValue("timdialogid"); //群ID 新增时默认传0
        String fimdialogname = content.getString("fimdialogname");//群名称
        String fimdialogtype = content.getString("fimdialogtype");//对话类型
        String ownertable = content.getString("ownertable");//所有表
        String ownerid = content.getString("ownerid");//所有表ID

        ArrayList<String> sqlList = new ArrayList<>();

//        PaoSetRemote timdialogSet = getP2ServerSystemPaoSet("timdialog", "siteid='" + siteid + "' and timdialogid='" + timdialogid + "'");
//        PaoRemote timdialog = null;
//        if (timdialogid <= 0 || timdialogSet.isEmpty()) {
//            /**
//             * 创建对话框
//             */
//            timdialog = timdialogSet.addAtEnd();
//            timdialog.setValue("siteid", siteid, 11L);//企业ID
//            timdialog.setValue("createby", username, 11L);//创建人
//            timdialog.setValue("createdate", sysdate, 11L);//创建时间
//            timdialog.setValue("fimdialogtype", fimdialogtype, 11L);//对话框类型
//            timdialog.setValue("ownertable", ownertable, 11L);//所有表
//            timdialog.setValue("ownerid", ownerid, 11L);//所有表ID
//            timdialog.setValue("userid", userid, 11L);//创建账号ID
//            timdialogid = timdialog.getUniqueIDValue();
//        } else {
//            timdialog = timdialogSet.getPao(0);
//        }
//        timdialog.setValue("fimdialogname", fimdialogname, 11L);//对话框类型
//        timdialogSet.save();
        /**
         * 在初始对话框中添加人员
         */
        JSONArray usersArray = content.getJSONArray("users");
        ArrayList<String> userlist = new ArrayList<>();
        usersArray.add(userid);//默认将创建人员加入群
        for (Object user : usersArray) {
            userlist.add(String.valueOf(user));
        }
        SQLFactory sqlFactory = new SQLFactory(this, "即时通讯群人员添加");
        sqlFactory.addParameter("createby", username);
        sqlFactory.addParameter("timdialogid", timdialogid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_in("userid", userlist);
        sqlList.add(sqlFactory.getSQL());
        dbConnect.runSqlUpdate(sqlList);
        content.put("timdialogid", timdialogid);
        return query_imdialogMain();
    }

    /**
     * 更新群成员信息
     *
     * @return
     */
    public String updateDialoguser() throws YosException {
        long timdialogid = content.getLongValue("timdialogid");
        long userid = content.getLong("userid");
        String fimdialognotes = content.getString("fimdialognotes");
        int fisremove = content.getIntValue("fisremove");
        dbConnect.runSqlUpdate("update timdialogusers set fisremove=" + fisremove + ",fimdialognotes='" + fimdialognotes + "' where siteid='" + siteid + "' and timdialogid='" + timdialogid + "' and userid='" + userid + "'");
        return getSucReturnObject().toString();
    }
}
