package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_paycoupon implements YosObject {
    @Override
    public String table_comment() {
        return "账号付款优惠券";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_paycouponid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new DecimalCol("amount", "抵扣金额", "抵扣金额", 16, 2, true, false, 0));
        arrayList.add(new DateCol("enddate", "优惠券截止日期", "优惠券截止日期", false, false, "", 0));
        arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", false, false, false, 0));
        arrayList.add(new BigIntCol("sys_payorderid", "账号付费订单ID", "账号付费订单ID", true, false, false, 0));
        arrayList.add(new IntCol("accountqty", "赠送账号数", "赠送账号数", true, false, false, 0, 0));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
        arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", false, false, "", 0));
        arrayList.add(new IntCol("days", "赠送天数", "赠送天数", true, false, false, 0, 0));
        arrayList.add(new VarcharCol("type", "优惠类型", "优惠类型：账号、金额、时效", 50, false, false, false, "金额", 0));
        arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 0));
        arrayList.add(new BigIntCol("sa_agentsid", "经销商ID", "经销商ID", false, false, false, 0));
        return arrayList;
    }
    @Override
    public void DataInit() throws YosException {

    }
}
