package utility.tools;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Random;

/**
 * 快速计算工具
 */
public class Math {

    /**
     * 加法
     *
     * @param arg0
     * @param arg1
     * @return
     */
    public static double add(double arg0, double arg1) {
        BigDecimal b1 = new BigDecimal(Double.toString(arg0));
        BigDecimal b2 = new BigDecimal(Double.toString(arg1));
        return b1.add(b2).doubleValue();
    }

    /**
     * 减法
     *
     * @param arg0 被减数
     * @param arg1 减数
     * @return
     */
    public static double sub(double arg0, double arg1) {
        BigDecimal b1 = new BigDecimal(Double.toString(arg0));
        BigDecimal b2 = new BigDecimal(Double.toString(arg1));
        return b1.subtract(b2).doubleValue();
    }

    /**
     * 乘法
     *
     * @param arg0
     * @param arg1
     * @return
     */
    public static double mul(double arg0, double arg1) {
        BigDecimal b1 = new BigDecimal(Double.toString(arg0));
        BigDecimal b2 = new BigDecimal(Double.toString(arg1));
        return b1.multiply(b2).doubleValue();
    }

    /**
     * 乘法
     *
     * @param arg0
     * @param arg1
     * @return
     */
    public static double mul(double arg0, double arg1, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(arg0));
        BigDecimal b2 = new BigDecimal(Double.toString(arg1));

        return round(b1.multiply(b2).doubleValue(), scale);
    }

    /**
     * 除法，默认保留6位
     *
     * @param arg0
     * @param arg1
     * @return
     */
    public static double div(double arg0, double arg1) {
        return div(arg0, arg1, 6);
    }

    /**
     * 除法
     *
     * @param arg0  被除数
     * @param arg1  除数
     * @param scale 需要精确到小数点以后几位
     * @return
     */
    public static double div(double arg0, double arg1, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("精度不能小于0");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(arg0));
        BigDecimal b2 = new BigDecimal(Double.toString(arg1));
        return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    /**
     * 四舍五入处理。
     *
     * @param arg0  需要四舍五入的数字
     * @param scale 小数点后保留几位
     * @return 四舍五入后的结果
     */
    public static Double round(double arg0, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("保留位数不能小于0");
        }
        BigDecimal b = new BigDecimal(Double.toString(arg0));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    /**
     * 获取随机数
     *
     * @return
     */
    public static double random() {
        return java.lang.Math.random();
    }

    public static String random(int len) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; i++) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }
    /**
     * 计算百分比，保留2位数
     *
     * @param x
     * @param y
     * @return 50%
     */
    public static String getPercent(long x, long y) {
        double d1 = x * 1.0;
        double d2 = y * 1.0;
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        // 设置保留几位小数，这里设置的是保留两位小数
        percentInstance.setMinimumFractionDigits(2);
        return percentInstance.format(d1 / d2);
    }

}
