package utility.hardware;

import com.sun.management.OperatingSystemMXBean;
import utility.tools.Math;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class Memory {
    private long totalMemory;
    private long usedMemory;
    private double memoryUsagePercent;

    private long heapMaxMemory;
    private long heapUsedMemory;
    private double heapMemoryUsagePercent;

    public long getTotalMemory() {
        return totalMemory;
    }

    public long getUsedMemory() {
        return usedMemory;
    }

    public double getMemoryUsagePercent() {
        return memoryUsagePercent;
    }

    public long getHeapMaxMemory() {
        return heapMaxMemory;
    }

    public long getHeapUsedMemory() {
        return heapUsedMemory;
    }

    public double getHeapMemoryUsagePercent() {
        return heapMemoryUsagePercent;
    }

    private static Memory memory = new Memory();

    public static Memory get() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        long totalMemory = osBean.getTotalPhysicalMemorySize();
        long usedMemory = totalMemory - osBean.getFreePhysicalMemorySize();

        memory.totalMemory = totalMemory / 1024 / 1024;
        memory.usedMemory = usedMemory / 1024 / 1024;
        memory.memoryUsagePercent = Math.round(((double) usedMemory / totalMemory) * 100, 2);

        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();      // 堆内存使用情况
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        long heapUsedMemory = heapMemoryUsage.getUsed();
        long heapMaxMemory = heapMemoryUsage.getMax();

        memory.heapMaxMemory = heapMaxMemory / 1024 / 1024;
        memory.heapUsedMemory = heapUsedMemory / 1024 / 1024;
        memory.heapMemoryUsagePercent = Math.round((double) heapUsedMemory / heapMaxMemory * 100, 2);
        return memory;
    }
}
