package common.data;

import com.alibaba.fastjson.JSONArray;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.HashMap;

public class BaseSQL<T> extends BaseClass {
    protected String tablename;
    protected String table_alias;
    protected ArrayList<String> wherelist = new ArrayList<>();
    public String uniquecolumnname;
    protected Controller controller = null;
    protected HashMap<String, ArrayList<String>> tableColumnNames = new HashMap<>();

    protected BaseSQL(Controller controller, String tablename) throws YosException {
        this.tablename = tablename;
        this.table_alias = tablename;
        this.uniquecolumnname = getuniquecolumnname(tablename);
        this.dbConnect = controller.dbConnect;
        this.controller = controller;
        this.tableColumnNames.put(this.tablename, getTableColumnNames(this.tablename));
    }

    protected BaseSQL(DBConnect dbConnect, String tablename) throws YosException {
        this.tablename = tablename;
        this.table_alias = tablename;
        this.uniquecolumnname = getuniquecolumnname(tablename);
        this.dbConnect = dbConnect;
        this.tableColumnNames.put(this.tablename, getTableColumnNames(this.tablename));
    }

    /**
     * 快速设置站点条件
     *
     * @param siteid
     * @return
     */
    public T setSiteid(String siteid) {
        wherelist.add(this.table_alias + "." + "siteid ='" + siteid + "'");
        return (T) this;
    }

    /**
     * 快速设置id条件
     *
     * @param uniqueid
     * @return
     */
    public T setUniqueid(long uniqueid) {
        wherelist.add(this.table_alias + "." + this.uniquecolumnname + "=" + uniqueid);
        return (T) this;
    }

    /**
     * 为查询添加过滤条件，不同的where之间是 and 的关系，insertsql不适用
     *
     * @param key   字段，不指定表名的情况下，默认为主表字段
     * @param value 当值的类型为list或数组时，系统将视为in方法查询
     * @return
     */
    public T setWhere(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList) value;
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; i++) {
                values[i] = list.get(i).toString();
            }
            setWhere(key, values);
        } else if (value instanceof JSONArray) {
            JSONArray Objectarray = (JSONArray) value;
            Object[] values = new Object[Objectarray.size()];
            for (int i = 0; i < values.length; i++) {
                values[i] = Objectarray.get(i);
            }
            setWhere(key, values);
        } else if (value instanceof Boolean) {
            setWhere(key, (Boolean) value ? 1 : 0);
        } else if (value.getClass().isArray()) {
            Object[] Objectarray = (Object[]) value;
            String[] values = new String[Objectarray.length];
            for (int i = 0; i < values.length; i++) {
                values[i] = Objectarray[i].toString();
            }
            setWhere(key, values);
        } else {
            if (key.contains(".")) {
                wherelist.add(key + "='" + value + "'");
            } else {
                wherelist.add(table_alias + "." + key + "='" + value + "'");
            }
        }
        return (T) this;
    }

    /**
     * 为查询添加 in 过滤条件，不同的where之间是 and 的关系，insertsql不适用
     *
     * @param key   字段，不指定表名的情况下，默认为主表字段
     * @param value
     * @return
     */
    public T setWhere(String key, Object[] value) {
        String in_str = "";
        if (value.length > 0) {
            for (Object o : value) {
                in_str = in_str.equals("") ? ("'" + o + "'") : (in_str + ",'" + o + "'");
            }
        } else {
            in_str = "''";
        }
        if (key.contains(".")) {
            wherelist.add(key + " in (" + in_str + ")");
        } else {
            wherelist.add(table_alias + "." + key + " in (" + in_str + ")");
        }
        return (T) this;
    }

    /**
     * 自定义过滤条件查询，需自行指定表名
     *
     * @param where 允许添加参数，参数需要用$符号进行包裹
     * @return
     */
    public T setWhere(String where) {
        wherelist.add(where);
        return (T) this;
    }

    /**
     * SQL参数Map
     */
    private HashMap<String, Object> parametermap = new HashMap<>();
    /**
     * SQL参数Map
     */
    private HashMap<String, String[]> parametermap_array = new HashMap<>();

    /**
     * 参数注入
     *
     * @param key   用$包裹的参数名称
     * @param value
     */
    public void addParameter(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList) value;
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; i++) {
                values[i] = list.get(i).toString();
            }
            parametermap_array.put(key, values);
        } else if (value.getClass().isArray()) {
            Object[] Objectarray = (Object[]) value;
            String[] values = new String[Objectarray.length];
            for (int i = 0; i < values.length; i++) {
                values[i] = Objectarray[i].toString();
            }
            parametermap_array.put(key, values);
        } else {
            parametermap.put(key, value);
        }
    }

    /**
     * 参数值替换
     *
     * @param sql_str
     * @return
     */
    protected String parameterDo(String sql_str) {
        for (String key : this.parametermap.keySet()) {
            String sqlkey = "$" + key + "$";
            Object value = this.parametermap.get(key);
            if (value == null || "null".equalsIgnoreCase(value.toString())) {
                sql_str = sql_str.replace(sqlkey, "NULL");
            } else {
                sql_str = sql_str.replace(sqlkey, "'" + value + "'");
            }
        }
        for (String key : this.parametermap_array.keySet()) {
            String sqlkey = "$" + key + "$";
            String[] values = this.parametermap_array.get(key);
            if (values == null || values.length == 0) {
                sql_str = sql_str.replace(sqlkey, "('')");
            } else {
                StringBuilder instr = new StringBuilder();
                for (String value : values) {
                    if (instr.toString().equals("")) {
                        if (String.valueOf(value).equalsIgnoreCase("null")) {
                            instr = new StringBuilder("NULL");
                        } else {
                            instr = new StringBuilder("'" + value + "'");
                        }
                    } else {
                        if (String.valueOf(value).equalsIgnoreCase("null")) {
                            instr.append(",NULL");
                        } else {
                            instr.append(",'").append(value).append("'");
                        }
                    }
                }
                sql_str = sql_str.replace(sqlkey, "(" + instr + ")");
            }
        }
        return sql_str;
    }
}
