/*
 * Decompiled with CFR 0.152.
 */
package utility.valve;

import utility.valve.ValveUnit;

public class ValvePot {
    private ValveUnit.PUnit P_unit;
    private ValveUnit.QUnit Q_unit;
    private ValveUnit.VUnit V_unit;
    private double Pa = 10.339;
    private double Pv = 0.23;
    private double g = 9.81;
    private double \u03c1 = 1.0;
    private Medium medium;

    public ValvePot(Medium medium) {
        this.medium = medium;
        this.P_unit = ValveUnit.PUnit.mH2O;
        this.Q_unit = ValveUnit.QUnit.m3h;
        this.V_unit = ValveUnit.VUnit.ms;
    }

    public ValvePot() {
        this.medium = Medium.liquid;
        this.P_unit = ValveUnit.PUnit.mH2O;
        this.Q_unit = ValveUnit.QUnit.m3h;
        this.V_unit = ValveUnit.VUnit.ms;
    }

    public ValvePot(ValveUnit.PUnit p_unit, ValveUnit.QUnit q_unit, ValveUnit.VUnit v_unit) {
        this.medium = Medium.liquid;
        this.P_unit = p_unit;
        this.Q_unit = q_unit;
        this.V_unit = v_unit;
    }

    public ValvePot(Medium medium, ValveUnit.PUnit p_unit, ValveUnit.QUnit q_unit, ValveUnit.VUnit v_unit) {
        this.medium = medium;
        this.P_unit = p_unit;
        this.Q_unit = q_unit;
        this.V_unit = v_unit;
    }

    public ValveUnit.PUnit getP_unit() {
        return this.P_unit;
    }

    public ValveUnit.QUnit getQ_unit() {
        return this.Q_unit;
    }

    public ValveUnit.VUnit getV_unit() {
        return this.V_unit;
    }

    public void setPa(double pa) {
        this.Pa = pa;
    }

    public double getPa(ValveUnit.PUnit pUnit) {
        return ValveUnit.getPUnitValue(this.P_unit, this.Pa, pUnit);
    }

    public void setPv(double pv) {
        this.Pv = pv;
    }

    public double getPv(ValveUnit.PUnit pUnit) {
        return ValveUnit.getPUnitValue(this.P_unit, this.Pv, pUnit);
    }

    public void setG(double g) {
        this.g = g;
    }

    public double getG() {
        return this.g;
    }

    public void set\u03c1(double \u03c1) {
        this.\u03c1 = \u03c1;
    }

    public double get\u03c1() {
        return this.\u03c1;
    }

    static enum Medium {
        liquid,
        gas;

    }
}

