/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSON
implements Map<String, Object>,
Cloneable,
Serializable,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;
    public static HashMap<String, HashMap<String, Integer>> table_field_length_Map = new HashMap();

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean ordered) {
        this(16, ordered);
    }

    public JSONObject(int initialCapacity) {
        this(initialCapacity, false);
    }

    public JSONObject(int initialCapacity, boolean ordered) {
        this.map = ordered ? new LinkedHashMap<String, Object>(initialCapacity) : new HashMap<String, Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object val = this.map.get(key);
        if (val == null && key instanceof Number) {
            val = this.map.get(key.toString());
        }
        return val;
    }

    public JSONObject getJSONObject(String key) throws YosException {
        this.fieldContainsCheck(key, "JSONObject");
        Object value = this.map.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        if (value instanceof String) {
            return JSON.parseObject((String)((String)value));
        }
        return (JSONObject)JSONObject.toJSON((Object)value);
    }

    public JSONArray getJSONArray(String key) throws YosException {
        this.fieldContainsCheck(key, "JSONArray");
        Object value = this.map.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof List) {
            return new JSONArray((List)value);
        }
        if (value instanceof String) {
            return (JSONArray)JSON.parse((String)((String)value));
        }
        return (JSONArray)JSONObject.toJSON((Object)value);
    }

    public <T> T getObject(String key, Class<T> clazz) throws YosException {
        this.fieldContainsCheck(key, clazz.getSimpleName());
        Object obj = this.map.get(key);
        return TypeUtils.castToJavaBean(obj, clazz);
    }

    public <T> T getObject(String key, Type type) throws YosException {
        this.fieldContainsCheck(key, type.getTypeName());
        Object obj = this.map.get(key);
        return TypeUtils.cast(obj, type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String key, TypeReference typeReference) throws YosException {
        this.fieldContainsCheck(key, typeReference.getType().getTypeName());
        Object obj = this.map.get(key);
        if (typeReference == null) {
            return (T)obj;
        }
        return TypeUtils.cast(obj, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String key) throws YosException {
        this.fieldContainsCheck(key, "Boolean");
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBoolean(value);
    }

    public byte[] getBytes(String key) throws YosException {
        this.fieldContainsCheck(key, "Bytes");
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBytes(value);
    }

    public boolean getBooleanValue(String key) {
        Object value = this.get(key);
        Boolean booleanVal = TypeUtils.castToBoolean(value);
        if (booleanVal == null) {
            return false;
        }
        return booleanVal;
    }

    public Byte getByte(String key) throws YosException {
        this.fieldContainsCheck(key, "Bytes");
        Object value = this.get(key);
        return TypeUtils.castToByte(value);
    }

    public byte getByteValue(String key) {
        Object value = this.get(key);
        Byte byteVal = TypeUtils.castToByte(value);
        if (byteVal == null) {
            return 0;
        }
        return byteVal;
    }

    public Short getShort(String key) throws YosException {
        this.fieldContainsCheck(key, "Short");
        Object value = this.get(key);
        return TypeUtils.castToShort(value);
    }

    public short getShortValue(String key) {
        Object value = this.get(key);
        Short shortVal = TypeUtils.castToShort(value);
        if (shortVal == null) {
            return 0;
        }
        return shortVal;
    }

    public Integer getInteger(String key) throws YosException {
        this.fieldContainsCheck(key, "Integer");
        Object value = this.get(key);
        return TypeUtils.castToInt(value);
    }

    public int getIntValue(String key) {
        Object value = this.get(key);
        Integer intVal = TypeUtils.castToInt(value);
        if (intVal == null) {
            return 0;
        }
        return intVal;
    }

    public int getIntValue(String key, int defaultvalue) {
        Object value = this.get(key);
        Integer intVal = TypeUtils.castToInt(value);
        if (intVal == null) {
            return defaultvalue;
        }
        return intVal;
    }

    public Long getLong(String key) throws YosException {
        if (BaseClass.isTableUniqueColumnName(key)) {
            return this.getLongValue(key, -1L);
        }
        this.fieldContainsCheck(key, "Long");
        Object value = this.get(key);
        return TypeUtils.castToLong(value);
    }

    public long getLongValue(String key) {
        Object value = this.get(key);
        Long longVal = TypeUtils.castToLong(value);
        if (longVal == null) {
            return 0L;
        }
        return longVal;
    }

    public long getLongValue(String key, Long defaultvalue) {
        Object value = this.get(key);
        Long longVal = TypeUtils.castToLong(value);
        if (longVal == null) {
            return defaultvalue;
        }
        return longVal;
    }

    public Float getFloat(String key) throws YosException {
        this.fieldContainsCheck(key, "Float");
        Object value = this.get(key);
        return TypeUtils.castToFloat(value);
    }

    public float getFloatValue(String key) {
        Object value = this.get(key);
        Float floatValue = TypeUtils.castToFloat(value);
        if (floatValue == null) {
            return 0.0f;
        }
        return floatValue.floatValue();
    }

    public Double getDouble(String key) throws YosException {
        this.fieldContainsCheck(key, "Double");
        Object value = this.get(key);
        return TypeUtils.castToDouble(value);
    }

    public double getDoubleValue(String key) {
        Object value = this.get(key);
        Double doubleValue = TypeUtils.castToDouble(value);
        if (doubleValue == null) {
            return 0.0;
        }
        return doubleValue;
    }

    public BigDecimal getBigDecimal(String key) throws YosException {
        this.fieldContainsCheck(key, "BigDecimal");
        Object value = this.get(key);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigDecimal getBigDecimalValue(String key) throws YosException {
        Object value = this.get(key);
        if (value == null || value.equals("")) {
            return TypeUtils.castToBigDecimal(0);
        }
        this.fieldContainsCheck(key, "BigDecimal");
        return TypeUtils.castToBigDecimal(value);
    }

    public BigDecimal getBigDecimalValue(String key, int defaultvalue) throws YosException {
        Object value = this.get(key);
        if (value == null || value.equals("")) {
            return TypeUtils.castToBigDecimal(defaultvalue);
        }
        this.fieldContainsCheck(key, "BigDecimal");
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String key) throws YosException {
        this.fieldContainsCheck(key, "BigInteger");
        Object value = this.get(key);
        return TypeUtils.castToBigInteger(value);
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, false);
    }

    public String getStringValue(String key, boolean Keepspecialcharacters, String defValue) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return defValue;
        }
        value = !Keepspecialcharacters ? value.toString().replaceAll("([';])+|(--)+", "") : value.toString().replace("'", "\\'");
        return value.toString();
    }

    public String getStringValueForDate(String key, String pattern, String defValue) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return defValue;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            sdf.parse(value.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return defValue;
        }
        return value.toString();
    }

    public String getStringValue(String key, boolean Keepspecialcharacters) {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        value = !Keepspecialcharacters ? value.toString().replaceAll("([';])+|(--)+", "") : value.toString().replace("'", "\\'");
        return value.toString();
    }

    public String getString(String key) throws YosException {
        return this.getString(key, false);
    }

    public String getString(String key, boolean Keepspecialcharacters) throws YosException {
        this.fieldContainsCheck(key, "String");
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        value = !Keepspecialcharacters ? value.toString().replaceAll("([';])+|(--)+", "") : value.toString().replace("'", "\\'");
        return value.toString();
    }

    public String getString(String key, String table_fieldname) throws YosException {
        return this.getString(key, table_fieldname, false);
    }

    public String getStringValue(String key, String table_fieldname) throws YosException {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        return this.getString(key, table_fieldname, false);
    }

    public String getString(String key, String table_fieldname, boolean Keepspecialcharacters) throws YosException {
        String[] split = table_fieldname.toUpperCase().split("[.]");
        String tablename = split[0];
        if (!table_field_length_Map.containsKey(tablename)) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            DBConnect dbConnect = new DBConnect();
            Rows rows = dbConnect.runSqlQuery("select column_name,numeric_precision from sys_objectcols where table_name='" + tablename + "'");
            for (Row row : rows) {
                map.put(row.getString("column_name").toUpperCase(), row.getInteger("numeric_precision"));
            }
            table_field_length_Map.put(tablename, map);
        }
        String fieldname = split.length == 1 ? key.toUpperCase() : split[1];
        int maxlength = table_field_length_Map.get(tablename).getOrDefault(fieldname, 0);
        return this.getString(key, maxlength, Keepspecialcharacters);
    }

    public String getStringValue(String key, String table_fieldname, boolean Keepspecialcharacters) throws YosException {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        return this.getString(key, table_fieldname, Keepspecialcharacters);
    }

    public String getString(String key, int maxlength) throws YosException {
        return this.getString(key, maxlength, false);
    }

    public String getStringValue(String key, int maxlength) throws YosException {
        return this.getStringValue(key, maxlength, false);
    }

    public String getString(String key, int maxlength, boolean Keepspecialcharacters) throws YosException {
        this.fieldContainsCheck(key, "String");
        String fieldvalue = this.getString(key);
        if (fieldvalue != null) {
            if (maxlength > 0 && fieldvalue.length() > maxlength) {
                throw new YosException("[" + key + "] \u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u5b57\u6570" + maxlength + "\u9650\u5236");
            }
            if (!Keepspecialcharacters) {
                fieldvalue = fieldvalue.replaceAll("([';])+|(--)+", "");
            }
        }
        return fieldvalue;
    }

    public String getStringValue(String key, int maxlength, boolean Keepspecialcharacters) throws YosException {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        return this.getString(key, maxlength, Keepspecialcharacters);
    }

    public java.util.Date getDate(String key) throws YosException {
        this.fieldContainsCheck(key, "Date");
        Object value = this.get(key);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(String key) throws YosException {
        this.fieldContainsCheck(key, "SqlDate");
        Object value = this.get(key);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(String key) throws YosException {
        this.fieldContainsCheck(key, "Timestamp");
        Object value = this.get(key);
        return TypeUtils.castToTimestamp(value);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    public JSONObject fluentPut(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public JSONObject fluentRemove(Object key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.map instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.map) : new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(args[0]);
            }
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE) {
                throw new JSONException("illegal setter");
            }
            String name = null;
            JSONField annotation = TypeUtils.getAnnotation(method, JSONField.class);
            if (annotation != null && annotation.name().length() != 0) {
                name = annotation.name();
            }
            if (name == null) {
                name = method.getName();
                if (!name.startsWith("set")) {
                    throw new JSONException("illegal setter");
                }
                if ((name = name.substring(3)).length() == 0) {
                    throw new JSONException("illegal setter");
                }
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            this.map.put(name, args[0]);
            return null;
        }
        if (parameterTypes.length == 0) {
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                throw new JSONException("illegal getter");
            }
            String name = null;
            JSONField annotation = TypeUtils.getAnnotation(method, JSONField.class);
            if (annotation != null && annotation.name().length() != 0) {
                name = annotation.name();
            }
            if (name == null) {
                name = method.getName();
                if (name.startsWith("get")) {
                    if ((name = name.substring(3)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                } else if (name.startsWith("is")) {
                    if ((name = name.substring(2)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                } else {
                    if (name.startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (name.startsWith("toString")) {
                        return this.toString();
                    }
                    throw new JSONException("illegal getter");
                }
            }
            Object value = this.map.get(name);
            return TypeUtils.cast(value, method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SecureObjectInputStream.ensureFields();
        if (SecureObjectInputStream.fields != null && !SecureObjectInputStream.fields_error) {
            SecureObjectInputStream secIn = new SecureObjectInputStream(in);
            try {
                secIn.defaultReadObject();
                return;
            }
            catch (NotActiveException notActiveException) {
                // empty catch block
            }
        }
        in.defaultReadObject();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key != null) {
                ParserConfig.global.checkAutoType(key.getClass());
            }
            if ((value = entry.getValue()) == null) continue;
            ParserConfig.global.checkAutoType(value.getClass());
        }
    }

    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == Map.class || clazz == JSONObject.class || clazz == JSON.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig config, int features) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, config);
    }

    public void fieldContainsCheck(String key, String classname) throws YosException {
        if (!this.containsKey(key)) {
            throw new YosException(this.getClass().getSimpleName() + "\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230\u540d\u4e3a" + key + "\u7684" + classname + "\u7c7b\u578b\u53c2\u6570\u4fe1\u606f");
        }
    }

    static class SecureObjectInputStream
    extends ObjectInputStream {
        static Field[] fields;
        static volatile boolean fields_error;

        static void ensureFields() {
            if (fields == null && !fields_error) {
                try {
                    Field[] declaredFields = ObjectInputStream.class.getDeclaredFields();
                    String[] fieldnames = new String[]{"bin", "passHandle", "handles", "curContext"};
                    Field[] array = new Field[fieldnames.length];
                    for (int i = 0; i < fieldnames.length; ++i) {
                        Field field = TypeUtils.getField(ObjectInputStream.class, fieldnames[i], declaredFields);
                        field.setAccessible(true);
                        array[i] = field;
                    }
                    fields = array;
                }
                catch (Throwable error) {
                    fields_error = true;
                }
            }
        }

        public SecureObjectInputStream(ObjectInputStream in) throws IOException {
            super(in);
            try {
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object value = field.get(in);
                    field.set(this, value);
                }
            }
            catch (IllegalAccessException e) {
                fields_error = true;
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (name.length() > 2) {
                int index = name.lastIndexOf(91);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                if (name.length() > 2 && name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
                    name = name.substring(1, name.length() - 1);
                }
                ParserConfig.global.checkAutoType(name, null, Feature.SupportAutoType.mask);
            }
            return super.resolveClass(desc);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            for (String interfacename : interfaces) {
                ParserConfig.global.checkAutoType(interfacename, null);
            }
            return super.resolveProxyClass(interfaces);
        }

        @Override
        protected void readStreamHeader() {
        }
    }
}

