/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.translate.Translate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.BaseClass;
import common.YosException;
import common.data.FieldMeta;
import common.data.Rows;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Row
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> fieldlist;
    private HashMap<String, FieldMeta> fieldMetaMap;

    public JSONObject toJsonObject() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public Object getValueAsObject(String fieldname) {
        return this.get(fieldname);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (this.containsKey("rowindex")) {
            m.remove("rowindex");
        }
        super.putAll(m);
    }

    public long getLong(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Long.parseLong(object.toString());
            }
            if (object instanceof Integer) {
                return ((Integer)object).intValue();
            }
            return (Long)object;
        }
        return 0L;
    }

    public long getLong(String fieldname, long defaultvalue) {
        return this.containsKey(fieldname) ? this.getLong(fieldname) : defaultvalue;
    }

    public float getFloat(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Float.parseFloat(object.toString());
            }
            if (object instanceof Integer) {
                return ((Float)object).floatValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).floatValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            return ((Float)object).floatValue();
        }
        return 0.0f;
    }

    public float getFloat(String fieldname, float defaultvalue) {
        return this.containsKey(fieldname) ? this.getFloat(fieldname) : defaultvalue;
    }

    public String getString(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object == null || String.valueOf(object).equalsIgnoreCase("null")) {
            return "";
        }
        return String.valueOf(object);
    }

    public String getString(String fieldname, String defaultvalue) {
        return this.containsKey(fieldname) ? this.getString(fieldname) : defaultvalue;
    }

    public Integer getInteger(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Integer.parseInt(object.toString());
            }
            if (object instanceof Long) {
                return new Long(object.toString()).intValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            if (object instanceof Double) {
                return ((Double)object).intValue();
            }
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return (Integer)object;
        }
        return 0;
    }

    public Integer getInteger(String fieldname, int defaultvalue) {
        return this.containsKey(fieldname) ? this.getInteger(fieldname) : defaultvalue;
    }

    public Short getShort(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Short.parseShort(object.toString());
            }
            if (object instanceof Long) {
                return new Long(object.toString()).shortValue();
            }
            if (object instanceof Integer) {
                return new Integer(object.toString()).shortValue();
            }
            if (object instanceof Boolean) {
                return new Integer((Boolean)object != false ? 1 : 0).shortValue();
            }
            return (Short)object;
        }
        return (short)0;
    }

    public Short getShort(String fieldname, short defaultvalue) {
        return this.containsKey(fieldname) ? this.getShort(fieldname) : defaultvalue;
    }

    public double getDouble(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Short) {
                return Double.parseDouble(object.toString());
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).doubleValue();
            }
        }
        return 0.0;
    }

    public double getDouble(String fieldname, double defaultvalue) {
        return this.containsKey(fieldname) ? this.getDouble(fieldname) : defaultvalue;
    }

    public BigDecimal getBigDecimal(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return new BigDecimal(object.toString());
            }
            if (object instanceof Integer) {
                return new BigDecimal((Integer)object);
            }
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
        }
        return new BigDecimal("0");
    }

    public BigDecimal getBigDecimal(String fieldname, BigDecimal defaultvalue) {
        return this.containsKey(fieldname) ? this.getBigDecimal(fieldname) : defaultvalue;
    }

    public Boolean getBoolean(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return "true".equalsIgnoreCase(object.toString()) || "1".equals(object.toString());
            }
            if (object instanceof Short) {
                return (Short)object == 1;
            }
            if (object instanceof Integer) {
                return (Integer)object == 1;
            }
            if (object instanceof Long) {
                return (Long)object == 1L;
            }
        }
        return false;
    }

    public Boolean getBoolean(String fieldname, Boolean defaultvalue) {
        return this.containsKey(fieldname) ? this.getBoolean(fieldname) : defaultvalue;
    }

    public Date getDate(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                String value = object.toString();
                if (value.length() == 10) {
                    value = value + " 00:00:00.0";
                }
                try {
                    return BaseClass.dateTimeFormat.parse(value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (object instanceof Date) {
                return (Date)this.getValueAsObject(fieldname);
            }
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
        }
        return null;
    }

    public Date getDate(String fieldname, Date defaultvalue) {
        return this.containsKey(fieldname) ? this.getDate(fieldname) : defaultvalue;
    }

    public JSONArray getJSONArray(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object instanceof String && object.toString().equals("")) {
            return new JSONArray();
        }
        try {
            return JSONArray.parseArray((String)object.toString());
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    public JSONArray getJSONArray(String fieldname, JSONArray defaultvalue) {
        return this.containsKey(fieldname) ? this.getJSONArray(fieldname) : defaultvalue;
    }

    public JSONObject getJSONObject(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object instanceof String && object.toString().equals("")) {
            return new JSONObject();
        }
        try {
            return JSONObject.parseObject((String)object.toString(), (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public JSONObject getJSONObject(String fieldname, JSONObject defaultvalue) {
        return this.containsKey(fieldname) ? this.getJSONObject(fieldname) : defaultvalue;
    }

    public Rows getRows(String linkname) {
        Object object = this.getValueAsObject(linkname);
        if (object instanceof Rows) {
            return (Rows)object;
        }
        return new Rows();
    }

    public Row getRow(String linkname) {
        Object object = this.getValueAsObject(linkname);
        if (object instanceof Row) {
            return (Row)object;
        }
        return new Row();
    }

    public String toXml() {
        Document document = DocumentHelper.createDocument();
        if (this.size() > 0) {
            Iterator it = this.keySet().iterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            Element root = document.addElement("rows");
            Element element = root.addElement("row0");
            for (String key : list) {
                Object value = this.get(key);
                Element e = element.addElement(key);
                if (value == null) {
                    e.addText("null");
                    continue;
                }
                e.addText(this.get(key).toString());
            }
        }
        return document.asXML();
    }

    public ArrayList<Object> toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String fieldname : this.keySet()) {
            list.add(this.get(fieldname));
        }
        return list;
    }

    public ArrayList<Object> toList(ArrayList<String> fieldnames) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String fieldname : fieldnames) {
            list.add(this.get(fieldname));
        }
        return list;
    }

    public <T> T toPOJO(T pojo) {
        try {
            Field[] pojofields;
            block27: for (Field field : pojofields = pojo.getClass().getFields()) {
                String fieldtype;
                String fieldname = field.getName();
                if (!this.containsKey(fieldname)) continue;
                switch (fieldtype = field.getType().getSimpleName()) {
                    case "String": {
                        field.set(pojo, this.getString(fieldname));
                        continue block27;
                    }
                    case "Date": {
                        field.set(pojo, this.getDate(fieldname));
                        continue block27;
                    }
                    case "Object": {
                        field.set(pojo, this.getValueAsObject(fieldname));
                        continue block27;
                    }
                    case "int": 
                    case "Integer": {
                        field.set(pojo, this.getInteger(fieldname));
                        continue block27;
                    }
                    case "long": 
                    case "Long": {
                        field.set(pojo, this.getLong(fieldname));
                        continue block27;
                    }
                    case "short": 
                    case "Short": {
                        field.set(pojo, this.getShort(fieldname));
                        continue block27;
                    }
                    case "double": 
                    case "Double": {
                        field.set(pojo, this.getBigDecimal(fieldname));
                        continue block27;
                    }
                    case "boolean": 
                    case "Boolean": {
                        field.set(pojo, this.getBoolean(fieldname));
                        continue block27;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pojo;
    }

    public void setFieldList(ArrayList<String> fieldlist) {
        this.fieldlist = fieldlist;
    }

    public ArrayList<String> getFieldList() {
        return this.fieldlist;
    }

    public HashMap<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public FieldMeta getFieldMeta(String fieldname) {
        return this.fieldMetaMap.get(fieldname);
    }

    public ArrayList<String> getTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FieldMeta fieldMeta : this.fieldMetaMap.values()) {
            if (arrayList.contains(fieldMeta.getTable_name())) continue;
            arrayList.add(fieldMeta.getTable_name());
        }
        return arrayList;
    }

    public void setFieldMetaMap(HashMap<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    @Deprecated
    public void setFieldTypeMap(HashMap<String, Class> keytypemap) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap();
        }
        for (String fieldname : keytypemap.keySet()) {
            FieldMeta fieldMeta = null;
            fieldMeta = this.fieldMetaMap.containsKey(fieldname) ? this.fieldMetaMap.get(fieldname) : new FieldMeta();
            fieldMeta.setFieldtype(keytypemap.get(fieldname));
            this.fieldMetaMap.put(fieldname, fieldMeta);
        }
    }

    public void translate_simple(String languagecode, String ... fieldnames) throws YosException {
        for (String fieldname : fieldnames) {
            this.put(fieldname, Translate.getSimpleTranslate(languagecode, this.getString(fieldname)));
        }
    }

    public void translate(String languagecode, String idcolumn, String ... fieldnames) throws YosException {
        for (String fieldname : fieldnames) {
            FieldMeta fieldMeta = this.getFieldMeta(fieldname);
            String tablename = fieldMeta.getTable_name();
            if (tablename.equals("")) continue;
            this.put(fieldname, Translate.getTranslate(languagecode, tablename, this.getLong(idcolumn), fieldMeta.getColumn_name(), this.getString(fieldname)));
        }
    }
}

