package utility.wechat.work.stopusing.media;

import com.alibaba.fastjson.JSONObject;
import common.YosException;
import utility.wechat.work.GetAccessToken;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;

/**
 * 查询素材
 *
 * @author Administrator
 */
public class Select {
    /**
     * 获取素材列表
     *
     * @param type   素材类型，可以为图文(mpnews)、图片（image）、音频（voice）、视频（video）、文件（file）
     * @param appid  企业应用的id，整型。可在应用的设置页面查看
     * @param offset 从该类型素材的该偏移位置开始返回，0表示从第一个素材 返回
     * @param count  返回素材的数量，取值在1到50之间
     * @return 返回jsonobject数据
     * @throws IOException
     */
    public String getList(String systemclient, String type, String appid, String offset, String count)
            throws IOException, YosException {
        URL url = new URL(
                "https://qyapi.weixin.qq.com/cgi-bin/material/batchget?access_token="
                        + GetAccessToken.get(systemclient));
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(
                connection.getOutputStream(), "utf-8");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", type);
        jsonObject.put("agentid", appid);
        jsonObject.put("offset", offset);
        jsonObject.put("count", count);
        out.write(jsonObject.toString());
        out.flush();
        out.close();
        // 获取媒体文件上传的输入流（从微信服务器读数据）
        BufferedReader in = new BufferedReader(new InputStreamReader(
                connection.getInputStream()));
        StringBuffer content = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            content.append(line);
        }
        in.close();
        // 测试打印结果
        return content.toString();

    }

    /**
     * 获取素材总数
     *
     * @param appid 企业应用的id，整型。可在应用的设置页面查看
     * @return 返回jsonobject数据
     * @throws IOException
     */
    public String count(String systemclient, String appid) throws IOException, YosException {
        URL url = new URL(
                "https://qyapi.weixin.qq.com/cgi-bin/material/get_count?access_token="
                        + GetAccessToken.get(systemclient) + "&agentid=" + appid);
        URLConnection connection = url.openConnection();

        // 获取媒体文件上传的输入流（从微信服务器读数据）
        BufferedReader in = new BufferedReader(new InputStreamReader(
                connection.getInputStream()));
        StringBuffer content = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            content.append(line);
        }
        in.close();
        // 测试打印结果
        return content.toString();
    }
}
