package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_payorder implements YosObject {
    @Override
    public String table_comment() {
        return "账号付费订单";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_payorderid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new DecimalCol("amount", "付费金额", "付费金额", 16, 2, true, false, 0));
        arrayList.add(new IntCol("sys_payincidence", "付费影响范围", "付费影响范围（付费类型）1，按账号，2按主体", true, false, false, 0));
        arrayList.add(new VarcharCol("orderno", "付费订单号", "付费订单号", 50, true, false, false, "", 0));
        arrayList.add(new SmallIntCol("ispaid", "付款状态", "0:已下单未付款，1：已付款，2：新建，3：已取消，4：已退款", false, false, false, 2, 0));
        arrayList.add(new TextCol("wechatpayorder", "微信支付订单查询结果", "微信支付订单查询结果", true, false, "", 0));
        arrayList.add(new DecimalCol("orig_amount", "原价", "原价", 16, 2, true, false, 0, 0));
        arrayList.add(new BigIntCol("sys_site_systempartitionid", "系统版本ID", "系统版本ID", false, false, false, 0));
        arrayList.add(new VarcharCol("out_refund_no", "商户退款单号", "商户退款单号", 200, true, false, false, "", 0));
        arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", false, false, "", 0));
        arrayList.add(new DateTimeCol("paytime", "付费时间", "付费时间", true, false, "", 0));
        arrayList.add(new VarcharCol("createby", "付费人", "付费人", 50, false, false, false, "", 0));
        arrayList.add(new SmallIntCol("deleted", "删除状态", "删除状态", true, false, false, 0, 0));
        arrayList.add(new VarcharCol("paymode", "付款方式", "付款方式（微信支付、现金支付、支付宝）", 50, true, false, false, "", 0));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
        arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", false, false, false, 0));
        arrayList.add(new VarcharCol("remarks", "备注", "备注", 500, true, false, false, "", 0));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
