/*
 * Decompiled with CFR 0.152.
 */
package utility.mysql;

import beans.parameter.Parameter;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import common.data.db.DBConnectPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import utility.zip.ZipUtil;

public class MysqlExport {
    private Statement stmt;
    private String database;
    private String tablename = "";
    private String datakey;

    public MysqlExport() throws YosException {
        this.datakey = "default";
        this.database = this.getDBname();
    }

    public MysqlExport(String datakey) throws YosException {
        this.datakey = datakey;
        this.database = this.getDBname();
    }

    public boolean export() {
        try {
            if (Parameter.get("system_db_backupswitch").equalsIgnoreCase("true") || Parameter.get("system_db_backupswitch").equalsIgnoreCase("1")) {
                DBConnectPool dbConnectPool = new DBConnectPool();
                DBConnectPool.YosConnection connection = dbConnectPool.getConnect(this.datakey);
                this.stmt = connection.getConnection().createStatement(1004, 1007);
                String path = Parameter.get("system_db_backuppath");
                File file = new File(path);
                if (!file.exists() && !file.mkdir()) {
                    throw new IOException("\u521b\u5efa\u5907\u4efd\u6587\u4ef6\u8def\u5f84\u5931\u8d25 " + file.getAbsolutePath());
                }
                String filepath = path + "/" + this.getSqlFilename();
                OutputStreamWriter oStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), StandardCharsets.UTF_8);
                this.exportToSql(oStreamWriter);
                oStreamWriter.close();
                dbConnectPool.close(connection);
                File sqlfile = new File(filepath);
                if (sqlfile.exists()) {
                    ZipUtil.zip(new File[]{sqlfile}, filepath.replace(".sql", ".zip"));
                    sqlfile.delete();
                }
                System.gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void exportToSql(OutputStreamWriter sqlWriter) throws SQLException, IOException, YosException {
        sqlWriter.append("/*");
        sqlWriter.append("\n Navicat Premium Data Transfer");
        sqlWriter.append("\n");
        sqlWriter.append("\n Source Server         : yos");
        sqlWriter.append("\n Source Server Type    : MySQL");
        sqlWriter.append("\n Source Server Version : 80028");
        sqlWriter.append("\n Source Host           : localhost:3306");
        sqlWriter.append("\n Source Schema         : ").append(this.database);
        sqlWriter.append("\n");
        sqlWriter.append("\n Target Server Type    : MySQL");
        sqlWriter.append("\n Target Server Version : 80028");
        sqlWriter.append("\n File Encoding         : 65001");
        sqlWriter.append("\n");
        sqlWriter.append("\n Date: 29/03/2023 08:43:12");
        sqlWriter.append("\n*/");
        sqlWriter.append("\n");
        sqlWriter.append("\nSET NAMES utf8mb4;");
        sqlWriter.append("\nSET FOREIGN_KEY_CHECKS = 0;");
        List<String> tables = this.getAllTables(this.database, this.stmt);
        for (String table : tables) {
            try {
                table = table.trim();
                sqlWriter.append(this.getTableInsertStatement(table));
                this.getDataInsertStatement(sqlWriter, table);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        sqlWriter.append(this.getViewInsertStatement(this.stmt));
        sqlWriter.append(this.getTriggersInsertStatement(this.stmt));
        sqlWriter.append("\n\nSET FOREIGN_KEY_CHECKS = 1;\n");
    }

    private String getTableInsertStatement(String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        if (table != null && !table.isEmpty()) {
            ResultSet rs = this.stmt.executeQuery("SHOW CREATE TABLE `" + table + "`;");
            while (rs.next()) {
                String tablename = rs.getString(1);
                String createtablesql = rs.getString(2);
                sql.append("\n\n-- ----------------------------");
                sql.append("\n").append("-- Table structure for ").append(tablename);
                sql.append("\n-- ----------------------------");
                sql.append("\nDROP TABLE IF EXISTS `").append(tablename).append("`;\n");
                sql.append(createtablesql).append(" ROW_FORMAT = Dynamic;");
            }
        }
        return sql.toString();
    }

    private void getDataInsertStatement(OutputStreamWriter sqlWriter, String table) throws SQLException, IOException {
        ResultSet rs = this.stmt.executeQuery("SELECT * FROM `" + table + "`;");
        rs.last();
        int rowCount = rs.getRow();
        if (rowCount <= 0) {
            return;
        }
        sqlWriter.append("\n\n-- ----------------------------").append("\n-- Records of ").append(table).append("\n-- ----------------------------\n");
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        rs.beforeFirst();
        while (rs.next()) {
            StringBuilder insertsql = new StringBuilder();
            insertsql.append("INSERT INTO `").append(table).append("` VALUES");
            insertsql.append("(");
            for (int i = 0; i < columnCount; ++i) {
                int columnType = metaData.getColumnType(i + 1);
                int columnIndex = i + 1;
                if (Objects.isNull(rs.getObject(columnIndex))) {
                    insertsql.append("NULL").append(", ");
                    continue;
                }
                if (columnType == -5) {
                    insertsql.append(rs.getLong(columnIndex)).append(", ");
                    continue;
                }
                if (columnType == 4 || columnType == -6 || columnType == -7 || columnType == 5) {
                    insertsql.append(rs.getInt(columnIndex)).append(", ");
                    continue;
                }
                String val = rs.getString(columnIndex);
                val = val.replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
                insertsql.append("'").append(val).append("', ");
            }
            insertsql.deleteCharAt(insertsql.length() - 1).deleteCharAt(insertsql.length() - 1);
            if (rs.isLast()) {
                insertsql.append(")");
            } else {
                insertsql.append(");\n");
            }
            sqlWriter.append(insertsql.toString());
        }
        sqlWriter.append(";");
    }

    private String getViewInsertStatement(Statement stmt) throws SQLException {
        StringBuilder sql = new StringBuilder();
        List<String> viewList = this.getAllViews(this.database, stmt);
        for (String viewname : viewList) {
            sql.append("\n\n-- ----------------------------");
            sql.append("\n-- View structure for ").append(viewname);
            sql.append("\n-- ----------------------------");
            sql.append("\nDROP VIEW IF EXISTS `").append(viewname).append("`;");
            try {
                Rows rows = new DBConnect().runSqlQuery("SHOW CREATE VIEW " + viewname + ";");
                for (Row row : rows) {
                    String viewsql = row.getString("Create View");
                    viewsql.replace("DEFINER=`root`@`localhost` ", "");
                    sql.append("\n").append(viewsql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sql.append(";");
        }
        return sql.toString();
    }

    private String getTriggersInsertStatement(Statement stmt) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ResultSet rs = stmt.executeQuery("SHOW TRIGGERS;");
        while (rs.next()) {
            String triggername = rs.getString("Trigger");
            String table = rs.getString("Table");
            sql.append("\n\n-- ----------------------------");
            sql.append("\n-- Triggers structure for table ").append(table);
            sql.append("\n-- ----------------------------");
            sql.append("\nDROP TRIGGER IF EXISTS `").append(triggername).append("`;");
            sql.append("\ndelimiter ;;");
            try {
                Rows rows = new DBConnect().runSqlQuery("SHOW CREATE TRIGGER " + triggername + ";");
                for (Row row : rows) {
                    String triggersql = row.getString("SQL Original Statement");
                    triggersql.replace("DEFINER=`root`@`localhost` ", "");
                    sql.append("\n").append(triggersql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sql.append("\n;;");
            sql.append("\ndelimiter ;;");
        }
        return sql.toString();
    }

    public String getSqlFilename() {
        if (this.tablename.equals("")) {
            return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "_" + this.database + ".sql";
        }
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "_" + this.database + "." + this.tablename + ".sql";
    }

    private List<String> getAllTables(String database2, Statement stmt) throws SQLException {
        ArrayList<String> table = new ArrayList<String>();
        ResultSet rs = this.tablename.equals("") ? stmt.executeQuery("SHOW TABLE STATUS FROM `" + database2 + "`;") : stmt.executeQuery("SHOW TABLE STATUS FROM `" + database2 + "` where Name='" + this.tablename + "';");
        while (rs.next()) {
            table.add(rs.getString("Name"));
        }
        for (String view : this.getAllViews(database2, stmt)) {
            table.remove(view);
        }
        return table;
    }

    private List<String> getAllViews(String database2, Statement stmt) throws SQLException {
        ArrayList<String> view = new ArrayList<String>();
        ResultSet rs = stmt.executeQuery("SHOW FULL TABLES from `" + database2 + "` WHERE TABLE_TYPE='VIEW';");
        while (rs.next()) {
            view.add(rs.getString("Tables_in_" + database2));
        }
        return view;
    }

    private String getDBname() throws YosException {
        return new DBConnect(this.datakey).getDBName();
    }
}

