/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.alibaba.fastjson.JSON;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.result.Field;
import common.YosException;
import common.YosLogger;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.data.db.SQLLog;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class DBConnect
implements YosLogger {
    private boolean createsqllog = false;
    private Long group_concat_max_len = 0L;
    public final String databasekey;
    private ArrayList<SQLLog> sqlLogList = new ArrayList();
    private int isArchiveDataSource = -1;
    public static HashMap<String, String> dbprodnamemap = new HashMap();

    public DBConnect() {
        this.databasekey = "default";
    }

    public DBConnect(String databasekey) {
        this.databasekey = databasekey;
    }

    public boolean isdefaultDataSource() {
        return this.databasekey.equalsIgnoreCase("default");
    }

    public boolean isArchiveDataSource() throws YosException {
        if (this.isArchiveDataSource == -1) {
            this.isArchiveDataSource = new DBConnect().runSqlQuery("select isdataarchive from sys_datasource where datakey='" + this.databasekey + "' and isdataarchive=1 ").isEmpty() ? 0 : 1;
        }
        return this.isArchiveDataSource == 1;
    }

    public String getDBName() throws YosException {
        if (this.databasekey.equals("default")) {
            return this.runSqlQuery(0, "select database() as dbname").getString("dbname");
        }
        return this.runSqlQuery(0, "select dbname from sys_datasource where datakey='" + this.databasekey + "'").getString("dbname");
    }

    public String getDBProduct() throws YosException {
        DBConnectPool.YosConnection yosConnection = DBConnectPool.getConnect(this.databasekey);
        String dbproduct = dbprodnamemap.getOrDefault(this.databasekey, this.getDBProduct(yosConnection.getConnection()));
        this.close(yosConnection, null);
        return dbproduct;
    }

    private String getDBProduct(Connection conn) {
        try {
            if (!dbprodnamemap.containsKey(this.databasekey)) {
                dbprodnamemap.put(this.databasekey, conn.getMetaData().getDatabaseProductName());
            }
            return dbprodnamemap.get(this.databasekey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setCreatesqllog(boolean createsqllog) {
        this.createsqllog = createsqllog;
    }

    public ArrayList<SQLLog> getSqlLogList() {
        return this.sqlLogList;
    }

    public void clearSqlLogList() {
        this.sqlLogList.clear();
    }

    public Row runSqlQuery(int index, SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory).get(index);
    }

    public Row runSqlQuery(int index, String SQL) throws YosException {
        return this.runSqlQuery(SQL).get(index);
    }

    public Rows runSqlQuery(SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory.getSQL(this));
    }

    public Rows runSqlQuery(String SQL) throws YosException {
        long starttimes = Calendar.getInstance().getTimeInMillis();
        DBConnectPool.YosConnection yosConnection = DBConnectPool.getConnect(this.databasekey);
        Connection conn = yosConnection.getConnection();
        if (conn == null) {
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25"));
            }
            throw new YosException(this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
        String DBProdName = this.getDBProduct(conn);
        Rows rows = new Rows();
        ResultSet resultSet = null;
        ResultSet found_rowsResultSet = null;
        PreparedStatement statement = null;
        long total = -1L;
        long pageTotal = -1L;
        long pageNumber = -1L;
        long pageSize = -1L;
        try {
            String str2;
            if (this.group_concat_max_len > 0L) {
                statement = conn.prepareStatement("SET group_concat_max_len = " + this.group_concat_max_len + ";");
                statement.executeUpdate();
                resultSet = statement.executeQuery(SQL);
            } else {
                statement = conn.prepareStatement(SQL);
                resultSet = statement.executeQuery();
            }
            java.sql.ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            if (DBProdName.equals("MySQL") && SQL.contains("SQL_CALC_FOUND_ROWS")) {
                statement = conn.prepareStatement("SELECT FOUND_ROWS()");
                found_rowsResultSet = statement.executeQuery();
                while (found_rowsResultSet.next()) {
                    total = found_rowsResultSet.getLong(1);
                }
            }
            ArrayList<String> colNameList = new ArrayList<String>();
            HashMap<String, FieldMeta> getFieldMetaMap = new HashMap<String, FieldMeta>();
            boolean contains_total = false;
            boolean contains_pageTotal = false;
            boolean contains_pageNumber = false;
            boolean contains_pageSize = false;
            for (int i = 0; i < colCount; ++i) {
                Object fields;
                String columnLabel = rsmd.getColumnLabel(i + 1);
                if (columnLabel.equals("total")) {
                    contains_total = true;
                    continue;
                }
                if (columnLabel.equals("pageTotal")) {
                    contains_pageTotal = true;
                    continue;
                }
                if (columnLabel.equals("pageNumber")) {
                    contains_pageNumber = true;
                    continue;
                }
                if (columnLabel.equals("pageSize")) {
                    contains_pageSize = true;
                    continue;
                }
                colNameList.add(columnLabel);
                FieldMeta fieldmeta = new FieldMeta();
                fieldmeta.setColumn_label(columnLabel);
                fieldmeta.setTable_name(rsmd.getTableName(i + 1));
                fieldmeta.setColumn_name(rsmd.getColumnName(i + 1));
                fieldmeta.setPrecision(rsmd.getPrecision(i + 1));
                fieldmeta.setScale(rsmd.getScale(i + 1));
                if (DBProdName.equals("MySQL") && ((Field[])(fields = ((ResultSetMetaData)rsmd).getFields())).length > i) {
                    fieldmeta.setTable_alias(fields[i].getTableName());
                }
                switch (rsmd.getColumnTypeName(i + 1).toLowerCase()) {
                    case "int": {
                        fieldmeta.setFieldtype(Integer.class);
                        break;
                    }
                    case "smallint": {
                        fieldmeta.setFieldtype(Short.class);
                        break;
                    }
                    case "bigint": {
                        fieldmeta.setFieldtype(Long.class);
                        break;
                    }
                    case "float": 
                    case "numeric": 
                    case "decimal": {
                        fieldmeta.setFieldtype(BigDecimal.class);
                        break;
                    }
                    case "date": 
                    case "datetime": {
                        fieldmeta.setFieldtype(Date.class);
                        break;
                    }
                    case "bit": 
                    case "boolean": {
                        fieldmeta.setFieldtype(Boolean.class);
                        break;
                    }
                    case "json": {
                        fieldmeta.setFieldtype(JSON.class);
                        break;
                    }
                    default: {
                        fieldmeta.setFieldtype(String.class);
                    }
                }
                getFieldMetaMap.put(columnLabel, fieldmeta);
            }
            boolean addrowindex = !colNameList.contains("rowindex");
            int rowindex = 1;
            while (resultSet.next()) {
                Row row = new Row();
                for (String colName : colNameList) {
                    FieldMeta fieldMeta = (FieldMeta)getFieldMetaMap.get(colName);
                    Class clazz = fieldMeta.getFieldtype();
                    Object value = null;
                    if (clazz == Integer.class) {
                        value = resultSet.getInt(colName);
                    } else if (clazz == Short.class) {
                        value = resultSet.getShort(colName);
                    } else if (clazz == Long.class) {
                        value = resultSet.getLong(colName);
                    } else if (clazz == BigDecimal.class) {
                        value = resultSet.getBigDecimal(colName);
                    } else if (clazz == Boolean.class) {
                        value = resultSet.getBoolean(colName);
                    } else if (clazz == JSON.class) {
                        value = JSON.parse((String)resultSet.getString(colName));
                    } else if (clazz == Date.class) {
                        value = resultSet.getString(colName);
                        if (value != null) {
                            value = ((String)value).replace(" 00:00:00.0", "");
                        }
                    } else {
                        Object objvalue = resultSet.getObject(colName);
                        value = objvalue == null ? "" : objvalue;
                    }
                    row.put(colName, value);
                    if (value == null) continue;
                    fieldMeta.setMaxValueLength(value.toString().length());
                }
                if (rowindex == 1) {
                    Object value;
                    if (contains_total) {
                        value = resultSet.getObject("total");
                        Object object = value = value == null ? Long.valueOf(0L) : value;
                        if (value instanceof Integer) {
                            total = total < 0L ? (long)((Integer)value).intValue() : total;
                        } else if (value instanceof Long) {
                            total = total < 0L ? (Long)value : total;
                        } else if (value instanceof BigDecimal) {
                            total = total < 0L ? ((BigDecimal)value).longValue() : total;
                        } else {
                            long l = total = total < 0L ? Long.parseLong(value.toString()) : total;
                        }
                    }
                    if (contains_pageTotal) {
                        value = resultSet.getObject("pageTotal");
                        Object object = value = value == null ? Long.valueOf(0L) : value;
                        if (value instanceof Long) {
                            pageTotal = pageTotal < 0L ? (Long)value : pageTotal;
                        } else if (value instanceof BigDecimal) {
                            pageTotal = pageTotal < 0L ? ((BigDecimal)value).longValue() : pageTotal;
                        } else if (value instanceof Double) {
                            pageTotal = pageTotal < 0L ? ((Double)value).longValue() : pageTotal;
                        } else if (value instanceof Float) {
                            pageTotal = pageTotal < 0L ? ((Float)value).longValue() : pageTotal;
                        } else if (value != null) {
                            long l = pageTotal = pageTotal < 0L ? Long.parseLong(value.toString()) : pageTotal;
                        }
                    }
                    if (contains_pageNumber) {
                        value = resultSet.getObject("pageNumber");
                        value = value == null ? Long.valueOf(0L) : value;
                        pageNumber = (Long)value;
                    }
                    if (contains_pageSize) {
                        value = resultSet.getObject("pageSize");
                        value = value == null ? Long.valueOf(0L) : value;
                        pageSize = (Long)value;
                    }
                }
                if (addrowindex) {
                    if (pageNumber > 0L && pageSize > 0L) {
                        row.put("rowindex", (pageNumber - 1L) * pageSize + (long)rowindex);
                    } else {
                        row.put("rowindex", rowindex);
                    }
                }
                row.setFieldList(colNameList);
                row.setFieldMetaMap(getFieldMetaMap);
                rows.add(row);
                ++rowindex;
            }
            if (contains_total && total == -1L) {
                try {
                    str2 = SQL.substring(0, SQL.indexOf(" as total"));
                    str2 = str2.substring(str2.lastIndexOf(" ") + 1);
                    total = Integer.parseInt(str2);
                }
                catch (Exception str2) {
                    // empty catch block
                }
            }
            if (contains_pageSize && pageSize == -1L) {
                try {
                    str2 = SQL.substring(0, SQL.indexOf(" as pageSize"));
                    str2 = str2.substring(str2.lastIndexOf(" ") + 1);
                    pageSize = Integer.parseInt(str2);
                }
                catch (Exception str3) {
                    // empty catch block
                }
            }
            if (contains_pageNumber && pageNumber == -1L) {
                try {
                    str2 = SQL.substring(0, SQL.indexOf(" as pageNumber"));
                    str2 = str2.substring(str2.lastIndexOf(" ") + 1);
                    pageNumber = Integer.parseInt(str2);
                }
                catch (Exception str4) {
                    // empty catch block
                }
            }
            if (contains_pageTotal && pageTotal == -1L) {
                try {
                    str2 = SQL.substring(0, SQL.indexOf(" as pageTotal"));
                    str2 = str2.substring(str2.lastIndexOf(" ") + 1);
                    pageTotal = Integer.parseInt(str2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (total > 0L) {
                rows.totalRows = total;
            }
            if (pageSize > 0L) {
                rows.pageSize = pageSize;
            }
            if (pageNumber > 0L) {
                rows.pageNumber = pageNumber;
            }
            if (pageTotal > 0L) {
                rows.totalPage = pageTotal;
            } else if (pageSize > 0L) {
                rows.totalPage = new Double(Math.ceil((double)total / (double)pageSize)).longValue();
            }
            if (rows.totalRows == 0L) {
                rows.totalRows = rows.size();
                rows.totalPage = 1L;
            }
            rows.setFieldList(colNameList);
            rows.setFieldMetaMap(getFieldMetaMap);
        }
        catch (SQLException e) {
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
            }
            throw new YosException(this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new YosException(e.getMessage());
                }
            }
            if (found_rowsResultSet != null) {
                try {
                    found_rowsResultSet.close();
                }
                catch (SQLException e) {
                    throw new YosException(e.getMessage());
                }
            }
            this.close(yosConnection, statement);
        }
        if (this.createsqllog) {
            this.sqlLogList.add(new SQLLog(SQL, Calendar.getInstance().getTimeInMillis() - starttimes, rows.size()));
        }
        return rows;
    }

    public int runSqlUpdate(SQLFactory sqlFactory) throws YosException {
        return this.runSqlUpdate(sqlFactory.getSQL());
    }

    public int runSqlUpdate(String SQL) throws YosException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SQL);
        return this.runSqlUpdate(list);
    }

    public int runSqlUpdate(ArrayList<String> SQLlist) throws YosException {
        int affectedrows = 0;
        boolean success = true;
        long starttimes = Calendar.getInstance().getTimeInMillis();
        DBConnectPool.YosConnection yosConnection = DBConnectPool.getConnect(this.databasekey);
        Connection conn = yosConnection.getConnection();
        if (conn == null) {
            if (this.createsqllog) {
                for (String SQL : SQLlist) {
                    this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25"));
                }
            }
            throw new YosException(this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
        PreparedStatement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                affectedrows += statement.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            success = false;
            String errmsg = e.getMessage();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                throw new YosException(e1.getMessage());
            }
            if (this.createsqllog) {
                if (SQLlist.size() == 1) {
                    this.sqlLogList.add(new SQLLog(SQLlist.get(0), this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
                } else if (SQLlist.size() > 1) {
                    this.sqlLogList.add(new SQLLog(JSON.toJSON(SQLlist).toString(), this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
                }
            }
            if (errmsg.startsWith("Duplicate entry") && errmsg.endsWith(".PRIMARY'")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace(".PRIMARY'", "");
                String[] s = errmsg.split(",");
                throw new YosException("\u8868" + s[1] + "\u4e3b\u952e ID\u3010" + s[0] + "\u3011\u91cd\u590d\uff01");
            }
            if (errmsg.startsWith("Duplicate entry")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace("'", "");
                String[] s = errmsg.split(",");
                throw new YosException("\u6570\u636e\u3010" + s[0] + "\u3011\u89e6\u53d1\u4e86\u552f\u4e00\u7d22\u5f15" + s[1]);
            }
            if (errmsg.startsWith("DataVersion conflict")) {
                throw new YosException("DataVersion conflict");
            }
            throw new YosException(this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + JSON.toJSON(SQLlist) + System.lineSeparator() + errmsg);
        }
        finally {
            this.close(yosConnection, statement);
        }
        if (success && this.createsqllog) {
            if (SQLlist.size() == 1) {
                this.sqlLogList.add(new SQLLog(SQLlist.get(0), Calendar.getInstance().getTimeInMillis() - starttimes, affectedrows));
            } else if (SQLlist.size() > 1) {
                this.sqlLogList.add(new SQLLog(JSON.toJSON(SQLlist).toString(), Calendar.getInstance().getTimeInMillis() - starttimes, affectedrows));
            }
        }
        return affectedrows;
    }

    private void close(DBConnectPool.YosConnection yosConnection, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        DBConnectPool.close(yosConnection);
    }

    public void setGroup_concat_max_len(Long group_concat_max_len) {
        this.group_concat_max_len = group_concat_max_len;
    }
}

