with recursive attachment as (
    select attachmentid
    from sys_attachment
    where siteid = $siteid$
      and attachmentid = $attachmentid$
    union all
    select t2.attachmentid
    from attachment t1
             inner join sys_attachment t2 on t1.attachmentid = t2.parentid and t2.siteid = $siteid$
)
select t1.attachmentid, t2.serialnumber, t2.type
from attachment t1
         inner join sys_attachment t2 on t1.attachmentid = t2.attachmentid and t2.siteid = $siteid$
order by t1.attachmentid
