package utility.wechat.wechatservice.core;

import common.data.Rows;
import common.data.db.DBConnect;
import utility.wechat.wechatservice.base.WXBizMsgCrypt;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.nio.charset.StandardCharsets;

/**
 * 企业微信消息接收接口
 */
public class wechatIndex extends HttpServlet implements wechatindexClient {
    private static final long serialVersionUID = 1L;

    @Override
    public String getSystemClient() {
        return null;
    }

    public wechatIndex() {
        super();
    }

    /**
     * 微信后端配置验证
     *
     * @param request
     * @param response
     * @throws ServletException
     * @throws IOException
     */
    protected void doGet(HttpServletRequest request,
                         HttpServletResponse response) throws ServletException, IOException {
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        String msg_signature = request.getParameter("msg_signature");
        String returnEchoStr; // 需要返回的明文
        try {
            DBConnect dbConnect = new DBConnect();
            Rows rows = dbConnect.runSqlQuery("select * from sys_wechatapp where systemclient='" + getSystemClient() + "'");
            if (rows.size() == 1) {
                WXBizMsgCrypt wxcpt;
                wxcpt = new WXBizMsgCrypt(rows.get(0).getString("work_token"),
                        rows.get(0).getString("work_encodingaeskey"), rows.get(0).getString("work_corpid"));
                returnEchoStr = wxcpt.verifyUrl(msg_signature, timestamp, nonce,
                        echostr);
                PrintWriter out = response.getWriter();
                out.print(returnEchoStr);
                out.flush();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 微信消息接收
     *
     * @param request
     * @param response
     * @throws ServletException
     * @throws IOException
     */
    protected void doPost(HttpServletRequest request,
                          HttpServletResponse response) throws ServletException, IOException {
        InputStream is = request.getInputStream();
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String msg_signature = request.getParameter("msg_signature");

        BufferedReader reader = new BufferedReader(new InputStreamReader(is,
                StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        is.close();
        try {
            DBConnect dbConnect = new DBConnect();
            Rows rows = dbConnect.runSqlQuery("select * from sys_wechatapp where systemclient='" + getSystemClient() + "'");
            if (rows.size() == 1) {
                WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(rows.get(0).getString("work_token"),
                        rows.get(0).getString("work_encodingaeskey"), rows.get(0).getString("work_corpid"));
                String finalxml = wxcpt.decryptMsg(msg_signature, timestamp, nonce,
                        sb.toString());

//                ReturnHandle handle = new ReturnHandle(getSystemClient(), finalxml);
//                String xml = handle.getReturnXML();
//                if (xml != null && !xml.equals("")) {
//                    String finalreturnxml = wxcpt.encryptMsg(xml, timestamp, nonce);
//                    response.setCharacterEncoding("utf-8");
//                    PrintWriter out = response.getWriter();
//                    out.print(finalreturnxml);
//                    out.flush();
//                    out.close();
//                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
