package utility.wechat.wechatservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import utility.tools.WebRequest;
import utility.wechat.miniprogram.WechatUserID;

import java.util.Calendar;
import java.util.HashMap;

/**
 * 微信公众号
 */
public class WechatService {

    //有效期2小时，需定时刷新，重复获取将导致上次获取的失效
    private static HashMap<String, String> access_tokenMap = new HashMap<>();
    private static HashMap<String, Long> access_token_timelimitMap = new HashMap<>();

    String appid;
    String secret;
    String systemclient;

    /**
     * 构造函数
     *
     * @param systemclient 系统注册的微信应用操作端
     */
    public WechatService(String systemclient) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select appid,secret from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.secret = rows.get(0).getString("secret");
        }
        this.systemclient = systemclient;
    }

    private String getAccessToken() throws YosException {
        long nowtime = Calendar.getInstance().getTimeInMillis();
        if (!access_tokenMap.containsKey(systemclient) || access_tokenMap.get(systemclient).equals("") || !access_token_timelimitMap.containsKey(systemclient) || access_token_timelimitMap.get(systemclient) < nowtime) {
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret;
            String res = new WebRequest().doGet(url);
            JSONObject resobject = JSONObject.parseObject(res);
            if (resobject.containsKey("access_token")) {
                access_tokenMap.put(systemclient, resobject.getString("access_token"));
                access_token_timelimitMap.put(systemclient, nowtime + 1000 * resobject.getIntValue("expires_in"));
            } else {
                access_tokenMap.put(systemclient, "");
            }
        }
        return access_tokenMap.get(systemclient);
    }

    public JSONArray getTemplate_List() throws YosException {
        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=" + getAccessToken();
        String result = new WebRequest().doGet(url);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("errcode").equals("40001")) {
            access_token_timelimitMap.remove(systemclient);
        }
        if (object.containsKey("template_list")) {
            return object.getJSONArray("template_list");
        }
        return new JSONArray();
    }

    /**
     * @param userid
     * @param template_id
     * @param client_msg_id          本地消息ID
     * @param tourl
     * @param datamap
     * @param tominiprogram_appid
     * @param tominiprogram_pagepath
     * @throws YosException
     */
    public void send(long userid, String template_id, String client_msg_id, String tourl, HashMap<String, String> datamap, String tominiprogram_appid, String tominiprogram_pagepath) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select openid from sys_wechatapp_openids where systemclient='" + systemclient + "' and userid=" + userid);
        for (Row row : rows) {
            JSONObject object = new JSONObject();
            object.put("touser", row.getString("openid"));
            object.put("template_id", template_id);
            if (!tourl.equals("")) {
                object.put("tourl", tourl);
            }
            if (!tominiprogram_appid.equals("") && !tominiprogram_pagepath.equals("")) {
                JSONObject miniprogramObject = new JSONObject();
                miniprogramObject.put("appid", tominiprogram_appid);
                miniprogramObject.put("pagepath", tominiprogram_pagepath);
                object.put("miniprogram", miniprogramObject);
            }
            object.put("client_msg_id", client_msg_id);
            JSONObject dataobject = new JSONObject();
            for (String keyword : datamap.keySet()) {
                JSONObject keyObject = new JSONObject();
                keyObject.put("value", datamap.get(keyword));
                dataobject.put(keyword, keyObject);
            }
            object.put("data", dataobject);

            String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + getAccessToken();
            new WebRequest().doPost(object.toString(), url);
        }
    }


    /**
     * 根据code获取微信的openid和unionid
     *
     * @param wechat_code
     * @return
     */
    public WechatUserID getWechatUserID(String wechat_code) throws YosException {
        WechatUserID wechatUserID = new WechatUserID();
        WebRequest request = new WebRequest();
        String result = request.doGet("https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + wechat_code + "&grant_type=authorization_code");
        JSONObject openidobject = JSONObject.parseObject(result);
        wechatUserID.setSucc(openidobject.containsKey("openid"));
        if (openidobject.containsKey("openid")) {
            wechatUserID.setOpenid(openidobject.getString("openid"));

            String result2 = request.doGet("https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + getAccessToken() + "&openid=" + openidobject.getString("openid") + "&lang=zh_CN");
            JSONObject unionidobject = JSONObject.parseObject(result2);

            if (unionidobject.containsKey("unionid")) {
                wechatUserID.setUnionid(unionidobject.getString("unionid"));
            }
        }
        wechatUserID.setResult(result);
        return wechatUserID;
    }

}
