package utility.bankdocking.ccb;

import beans.parameter.Parameter;
import common.YosException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.*;

public class XmlFactory {

    /**
     * @param STARTDATE 开始日期 20191101
     * @param ENDDATE   结束日期 20191101
     * @param PAGE      页数
     * @return
     */
    public String createGetBankDataXml(String siteid, int STARTDATE, int ENDDATE,
                                       int PAGE) throws YosException {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("GB2312");
        Element root = DocumentHelper.createElement("TX");

        root.addElement("REQUEST_SN").setText(String.valueOf(Calendar.getInstance().getTimeInMillis()));// 请求序列码,必填
        root.addElement("CUST_ID").setText(Parameter.get(siteid, "bank_ccb_cust_id"));// 客户号，必填
        root.addElement("USER_ID").setText(Parameter.get(siteid, "bank_ccb_user_id"));// 操作员号，必填
        root.addElement("PASSWORD").setText(Parameter.get(siteid, "bank_ccb_password"));// 密码，必填
        root.addElement("TX_CODE").setText("6WY101");// 6WY101，必填
        root.addElement("LANGUAGE").setText("CN");// 语言，必填

        Element TX_INFO = root.addElement("TX_INFO");
        TX_INFO.addElement("ACCNO1").setText(Parameter.get(siteid, "bank_ccb_accno"));// 账号,必填
        TX_INFO.addElement("STARTDATE").setText(String.valueOf(STARTDATE));// 开始时间,必填，YYYYMMDD
        TX_INFO.addElement("ENDDATE").setText(String.valueOf(ENDDATE));// 结束时间,必填，YYYYMMDD

        TX_INFO.addElement("BARGAIN_FLAG").setText("1");// 交易方向，表示转入 0-借 转出 ,1-贷 转入
        TX_INFO.addElement("CHECK_ACC_NO").setText("");// 对方账户
        TX_INFO.addElement("CHECK_ACC_NAME").setText("");// 对方账户名称
        TX_INFO.addElement("REMARK").setText("");// 备注
        TX_INFO.addElement("LOW_AMT").setText("");// 最小金额
        TX_INFO.addElement("HIGH_AMT").setText("");// 最大金额
        TX_INFO.addElement("PAGE").setText(String.valueOf(PAGE));// 起始页
        TX_INFO.addElement("POSTSTR").setText("");// 定位串
        TX_INFO.addElement("TOTAL_RECORD").setText("200");// 每页记录数
        TX_INFO.addElement("DET_NO").setText("");// 起始明细号
        TX_INFO.addElement("END_NO").setText("");// 截止明细号

        document.setRootElement(root);
        String xml = document.asXML();
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"GB2312\"?>",
                "<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\"?>");
        return xml;
    }

    public String getReturnCode(String xml) {
        String RETURN_CODE = "";
        try {
            Document document = DocumentHelper.parseText(xml);
            RETURN_CODE = document.getRootElement().element("RETURN_CODE").getText();
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        return RETURN_CODE;
    }

    public boolean getListByXml(ArrayList<HashMap<String, String>> arraylist, String xml) {
        try {
            Document document = DocumentHelper.parseText(xml);
            Element tx_infoelement = document.getRootElement().element("TX_INFO");
            String ACCNO1 = tx_infoelement.element("ACCNO1").getText();
            Element element = tx_infoelement.element("DETAILLIST");
            List infolist = element.elements("DETAILINFO");
            if (infolist.size() == 0) {
                return false;
            }
            Iterator it = infolist.iterator();
            while (it.hasNext()) {
                Element e = (Element) it.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TRANDATE", e.element("TRANDATE").getText());//交易日期
                map.put("TRANTIME", e.element("TRANTIME").getText());//交易时间
                map.put("CRE_TYP", e.element("CRE_TYP").getText());//凭证种类
                map.put("CRE_NO", e.element("CRE_NO").getText());//凭证号码
                map.put("MESSAGE", e.element("MESSAGE").getText());//摘要
                map.put("AMT", e.element("AMT").getText());//发生额
                map.put("AMT1", e.element("AMT1").getText());//余额
                map.put("FLAG1", e.element("FLAG1").getText());//借贷标志
                map.put("ACCNO2", e.element("ACCNO2").getText());//对方账号
                map.put("ACC_NAME1", e.element("ACC_NAME1").getText());//对方户名
                map.put("FLAG2", e.element("FLAG2").getText());//交易钞汇标志
                map.put("TRAN_FLOW", e.element("TRAN_FLOW").getText());//交易流水号
                map.put("BFLOW", e.element("BFLOW").getText());//企业支付流水号
                map.put("DET_NO", e.element("DET_NO").getText());//活存账户明细号
                map.put("DET", e.element("DET").getText());//备注
                map.put("REAL_TRANDATE", e.element("REAL_TRANDATE").getText());//交易日期
                map.put("RLTV_ACCNO", e.element("RLTV_ACCNO").getText());//关联账号
                map.put("CADBank_Nm", e.element("CADBank_Nm").getText());//对方账户开户行名称
                map.put("Ovrlsttn_Trck_No", e.element("Ovrlsttn_Trck_No").getText());//全局跟踪号
                map.put("ExoStm_Py_Rmrk", e.element("ExoStm_Py_Rmrk").getText());
                map.put("ACCNO1", ACCNO1);
                arraylist.add(map);
            }
        } catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}
