package restcontroller.sysmanage.develop.translate;

import beans.translate.Translate;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

public class translate extends Controller {


    public translate(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统翻译查询", apiversion = R.ID10026101.v1.class)
    public String querySimpleTranslateList() throws YosException {
        String languagecode = content.getStringValue("languagecode");

        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_translate", "translateid", "languagecode", "value_original", "value_translate");
        querySQL.setWhere("ifnull(ownertable,'')='' and ifnull(ownerid,0)=0 and ifnull(columnname,'')=''");
        querySQL.setWhere("languagecode", languagecode);
        querySQL.setCondition("value_original", "value_translate");
        querySQL.setOrderBy("value_original");
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统翻译新增修改", apiversion = R.ID10026201.v1.class)
    public String updateSimpleTranslate() throws YosException {
        long translateid = content.getLongValue("translateid");

        String languagecode = content.getString("languagecode");
        String value_original = content.getString("value_original");
        String value_translate = content.getString("value_translate");
        if (languagecode.equals("")) {
            return getErrReturnObject().setErrMsg("必须指定语言代码").toString();
        }
        if (value_original.equals("")) {
            return getErrReturnObject().setErrMsg("原值不可为空").toString();
        }
        if (value_translate.equals("")) {
            return getErrReturnObject().setErrMsg("翻译值不可为空").toString();
        }

        if (translateid <= 0) {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_translate");
            querySQL.setWhere("ifnull(ownertable,'')='' and ifnull(ownerid,0)=0 and ifnull(columnname,'')=''");
            querySQL.setWhere("languagecode", languagecode);
            querySQL.setWhere("value_original", value_original);
            if (querySQL.query().isNotEmpty()) {
                return getErrReturnObject().setErrMsg("该内容的指定语言翻译已存在").toString();
            }
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_translate");
            insertSQL.setValue("languagecode", languagecode);
            insertSQL.setValue("value_original", value_original);
            insertSQL.setValue("value_translate", value_translate);
            insertSQL.insert();
        } else {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_translate");
            querySQL.setWhere("ifnull(ownertable,'')='' and ifnull(ownerid,0)=0 and ifnull(columnname,'')=''");
            querySQL.setWhere("languagecode", languagecode);
            querySQL.setWhere("value_original", value_original);
            querySQL.setWhere("translateid!=" + translateid);
            if (querySQL.query().isNotEmpty()) {
                return getErrReturnObject().setErrMsg("该内容的指定语言翻译已存在").toString();
            }
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_translate");
            updateSQL.setValue("languagecode", languagecode);
            updateSQL.setValue("value_original", value_original);
            updateSQL.setValue("value_translate", value_translate);
            updateSQL.setUniqueid(translateid);
            updateSQL.update();
        }
        Translate.simpleTranslateMap.put(languagecode + "_" + value_original, value_translate);
        return getSucReturnObject().toString();
    }

    @API(title = "系统翻译删除", apiversion = R.ID10026301.v1.class)
    public String deleteSimpleTranslate() throws YosException {
        long translateid = content.getLongValue("translateid");
        Rows rows = dbConnect.runSqlQuery("select languagecode,value_original,value_translate from sys_translate where translateid=" + translateid);
        if (rows.isNotEmpty()) {
            String languagecode = rows.get(0).getString("languagecode");
            String value_original = rows.get(0).getString("value_original");
            Translate.simpleTranslateMap.remove(languagecode + "_" + value_original);
        }
        dbConnect.runSqlUpdate("delete from sys_translate where translateid=" + translateid);
        return getSucReturnObject().toString();
    }


    @API(title = "数据翻译查询", apiversion = R.ID2024062611091101.v1.class)
    public String queryDataTranslateList() throws YosException {
        String languagecode = content.getString("languagecode");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_translate");
        querySQL.setWhere("ifnull(ownertable,'')!='' and ifnull(ownerid,0)>0 and ifnull(columnname,'')!=''");
        querySQL.setWhere("languagecode", languagecode);
        querySQL.setCondition("value_translate");
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();
        for (Row row : rows) {
            String ownertable = row.getString("ownertable");
            String columnname = row.getString("columnname");
            row.put("tabletitle", getTableName(ownertable));
            row.put("columntitle", getTableColumnTitle(ownertable, row.getString("columnname")));

            try {
                Rows datarows = dbConnect.runSqlQuery("select " + columnname + " from " + ownertable + " where " + getuniquecolumnname(ownertable) + "=" + row.getLong("ownerid"));
                if (datarows.isNotEmpty()) {
                    row.put("value_original", datarows.get(0).getString(columnname));
                } else {
                    row.put("errmsg", "数据不存在");
                }
            } catch (Exception e) {
                row.put("errmsg", "数据不存在");
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "新增修改一个数据内容翻译", apiversion = R.ID10027001.v1.class)
    public String createDataTranslate() throws YosException {
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLong("ownerid");
        String lcode = content.getString("languagecode");
        String columnname = content.getString("columnname");
        String value_translate = content.getString("value_translate");
        Translate.addTranslate(lcode, ownertable, ownerid, columnname, value_translate);
        return getSucReturnObject().toString();
    }

    @API(title = "查询一个数据内容翻译", apiversion = R.ID10027101.v1.class)
    public String queryDataTranslate() throws YosException {
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLong("ownerid");
        String lcode = content.getString("languagecode");
        String columnname = content.getString("columnname");
        return getSucReturnObject().setData(Translate.getTranslate(lcode, ownertable, ownerid, columnname)).toString();
    }

    @API(title = "web端语言选择", apiversion = R.ID10026401.v1.class, accesstoken = false)
    public String languageSelect() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select languagecode,languagename from sys_language where isused=1");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "语言对照表查询全部", apiversion = R.ID2024062809072801.v1.class, accesstoken = false)
    public String queryAllSimpleTranslateList() throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_translate", "languagecode", "value_original", "value_translate");
        querySQL.setWhere("ifnull(ownertable,'')='' and ifnull(ownerid,0)=0 and ifnull(columnname,'')='' and ifnull(value_original,'')!=''and ifnull(value_translate,'')!=''");
        if (content.containsKey("languagecode")) {
            querySQL.setWhere("languagecode", content.getString("languagecode"));
        }
        Rows rows = querySQL.query();

        JSONObject resultObject = new JSONObject();
        for (Row row : rows) {
            String languagecode = row.getString("languagecode");
            String value_original = row.getString("value_original");
            String value_translate = row.getString("value_translate");

            JSONObject languageObject;
            if (resultObject.containsKey(languagecode)) {
                languageObject = resultObject.getJSONObject(languagecode);
            } else {
                languageObject = new JSONObject();
            }
            languageObject.put(value_original, value_translate);

            resultObject.put(languagecode, languageObject);
        }
        return getSucReturnObject().setData(resultObject).toString();
    }
}
