/*
 * Decompiled with CFR 0.152.
 */
package swing.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ComponentListener;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import swing.YUIParameter;
import swing.controls.Yui;

public abstract class YFrame
extends JFrame
implements Yui {
    public YFrame() throws HeadlessException {
        this.initialize();
    }

    public YFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public YFrame(String title) throws HeadlessException {
        super(title);
        this.initialize();
    }

    public YFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setIcon("logo.ico");
        this.setDefaultCloseOperation(3);
        this.setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half) / 2 - 100, YUIParameter.screen_width_half, YUIParameter.screen_height_half);
        this.init();
        this.view();
        this.data();
        this.control();
    }

    public void setIcon(String iconname) {
        try {
            String path = this.getClass().getResource("/").toURI().getPath() + "com/sui/media/images/" + iconname;
            this.setIconImage(new ImageIcon(path).getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBackground(String imagename) {
        try {
            String path = this.getClass().getResource("/").toURI().getPath() + "com/sui/media/images/" + imagename;
            ImageIcon backgroundImage = new ImageIcon(path);
            JLabel label = new JLabel(backgroundImage);
            label.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.getLayeredPane().add((Component)label, new Integer(Integer.MIN_VALUE));
            ((JPanel)this.getContentPane()).setOpaque(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
    }

    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            this.addWindowFocusListener((WindowFocusListener)obj);
            this.addWindowStateListener((WindowStateListener)obj);
            this.addComponentListener((ComponentListener)obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBoundsType(BoundsType boundsType) {
        switch (boundsType) {
            case full: {
                this.setBounds(0, 0, YUIParameter.screen_width, YUIParameter.screen_height);
                break;
            }
            case half: {
                this.setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half) / 2 - 100, YUIParameter.screen_width_half, YUIParameter.screen_height_half);
                break;
            }
            case small: {
                this.setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half / 3 * 2) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half / 3 * 2) / 2 - 100, YUIParameter.screen_width_half / 3 * 2, YUIParameter.screen_height_half / 3 * 2);
            }
        }
    }

    public static enum BoundsType {
        full,
        half,
        small;

    }
}

