/*
 * Decompiled with CFR 0.152.
 */
package swing.controls;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import swing.YUIParameter;

public class YButton
extends JButton {
    public YButton(String title) {
        super(title);
        this.init();
    }

    public YButton(String title, int width, int height) {
        this(title);
        this.setPreferredSize(new Dimension(width, height));
    }

    public YButton(String title, ButtonSize buttonSize) {
        this(title);
        switch (buttonSize) {
            case small: {
                this.setPreferredSize(new Dimension(50, 23));
                break;
            }
            case normal: {
                this.setPreferredSize(new Dimension(60, 30));
            }
        }
    }

    private void init() {
        this.setBackground(Color.white);
        if (YUIParameter.isdebug.booleanValue()) {
            this.setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            this.addActionListener((ActionListener)obj);
            this.addFocusListener((FocusListener)obj);
            this.addMouseListener((MouseListener)obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum ButtonSize {
        normal,
        small;

    }
}

