/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import common.YosException;
import common.data.Rows;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTableData;
import java.util.HashMap;
import java.util.Set;

public class SQLiteTable {
    private String tablename;
    HashMap<String, FieldType> map = new HashMap();

    public static SQLiteTable getTable(String tablename) {
        SQLiteTable sqLiteTable = new SQLiteTable();
        sqLiteTable.setTablename(tablename);
        return sqLiteTable;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void addColumn(String columnname, FieldType fieldtype) {
        this.map.put(columnname, fieldtype);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public FieldType getFieldType(String columnname) {
        return this.map.get(columnname);
    }

    public boolean dosNotExist() {
        return SQLiteMemory.runSqlQuery("SELECT * FROM sqlite_master WHERE type='table' AND name ='" + this.tablename + "'").isEmpty();
    }

    public void create() throws YosException {
        if (this.keySet().isEmpty()) {
            throw new YosException("\u6ca1\u6709\u4e3a\u8868" + this.tablename + "\u8bbe\u7f6e\u4efb\u4f55\u5b57\u6bb5\u4fe1\u606f");
        }
        if (this.dosNotExist()) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("CREATE TABLE " + this.tablename + "(");
            Set<String> tableColumnSet = this.keySet();
            boolean isfirst = true;
            for (String columnname : tableColumnSet) {
                if (isfirst) {
                    sqlBuffer.append(columnname).append(" ").append(this.getFieldType(columnname).toString());
                    isfirst = false;
                    continue;
                }
                sqlBuffer.append(",").append(columnname).append(" ").append(this.getFieldType(columnname).toString());
            }
            sqlBuffer.append(");");
            SQLiteMemory.runSqlUpdate(sqlBuffer.toString());
        }
    }

    public SQLiteTableData makeData() {
        return new SQLiteTableData(this);
    }

    public Rows getData(String where) {
        if (where.contains("where")) {
            where = where.replace("where", "");
        }
        return SQLiteMemory.runSqlQuery("select * from " + this.tablename + " where " + where);
    }

    public void deleteData(String where) {
        if (where.contains("where")) {
            where = where.replace("where", "");
        }
        SQLiteMemory.runSqlUpdate("delete from " + this.tablename + " where " + where);
    }

    public void cleanTable() {
        SQLiteMemory.runSqlUpdate("delete from " + this.tablename + " where 1=1");
    }

    public void dropTable() {
        SQLiteMemory.runSqlUpdate("drop table " + this.tablename);
    }

    public static enum FieldType {
        VARCHAR,
        BIGINT,
        INT,
        DATE,
        DATETIME;

    }
}

