/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import common.Controller;
import common.YosException;
import common.data.BaseSQL;
import common.data.QuerySQL;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import java.util.ArrayList;

public class RecursiveQuerySQL
extends BaseSQL<RecursiveQuerySQL> {
    private String cache_tableName;
    private String keyfieldname;
    private String linkkeyfieldname;
    private boolean forward = true;
    private boolean includekeydata = true;
    private ArrayList<String> queryfieldnames = new ArrayList();

    protected RecursiveQuerySQL(Controller controller, String tablename, String linkkeyfieldname) throws YosException {
        super(controller, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = this.uniquecolumnname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname\u548ckeyfieldname\u5b57\u6bb5\u76f8\u540c\uff01");
        }
    }

    protected RecursiveQuerySQL(DBConnect dbConnect, String tablename, String linkkeyfieldname) throws YosException {
        super(dbConnect, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = this.uniquecolumnname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname\u548ckeyfieldname\u5b57\u6bb5\u76f8\u540c\uff01");
        }
    }

    protected RecursiveQuerySQL(Controller controller, String tablename, String keyfieldname, String linkkeyfieldname) throws YosException {
        super(controller, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = keyfieldname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname\u548ckeyfieldname\u5b57\u6bb5\u76f8\u540c\uff01");
        }
    }

    protected RecursiveQuerySQL(DBConnect dbConnect, String tablename, String keyfieldname, String linkkeyfieldname) throws YosException {
        super(dbConnect, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = keyfieldname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname\u548ckeyfieldname\u5b57\u6bb5\u76f8\u540c\uff01");
        }
    }

    @Override
    public RecursiveQuerySQL setUniqueid(long uniqueid) throws YosException {
        this.wherelist.add(this.table_alias + "." + this.uniquecolumnname + "=" + uniqueid);
        return this;
    }

    public RecursiveQuerySQL setUniqueid(long uniqueid, boolean forward, boolean includekeydata) throws YosException {
        this.setUniqueid(uniqueid);
        this.forward = forward;
        this.includekeydata = includekeydata;
        return this;
    }

    public String getSQL() throws YosException {
        StringBuilder recursiveSQl = new StringBuilder();
        StringBuffer whereBuffer = new StringBuffer();
        for (String where : this.wherelist) {
            if (whereBuffer.toString().equals("")) {
                whereBuffer.append(" where ").append(this.parameterDo(where));
                continue;
            }
            whereBuffer.append(" and ").append(this.parameterDo(where));
        }
        if (this.forward) {
            recursiveSQl.append(" with recursive " + this.cache_tableName + " as ( ");
            recursiveSQl.append(" select " + this.keyfieldname + " from " + this.tablename).append(whereBuffer);
            recursiveSQl.append(" union all ");
            recursiveSQl.append(" select " + this.tablename + "." + this.keyfieldname + " from " + this.tablename + " inner join " + this.cache_tableName + " on " + this.tablename + "." + this.linkkeyfieldname + " = " + this.cache_tableName + "." + this.keyfieldname);
            recursiveSQl.append(" )");
            recursiveSQl.append("select * from " + this.cache_tableName);
            if (!this.includekeydata) {
                recursiveSQl.append(" where " + this.keyfieldname + " not in (select " + this.keyfieldname + " from " + this.tablename + whereBuffer + ")");
            }
        } else {
            recursiveSQl.append(" with recursive " + this.cache_tableName + " as ( ");
            recursiveSQl.append(" select " + this.linkkeyfieldname + " from " + this.tablename).append(whereBuffer);
            recursiveSQl.append(" union all ");
            recursiveSQl.append(" select " + this.tablename + "." + this.linkkeyfieldname + " from " + this.tablename + " inner join " + this.cache_tableName + " on " + this.tablename + "." + this.linkkeyfieldname + " is not null and " + this.tablename + "." + this.keyfieldname + " = " + this.cache_tableName + "." + this.linkkeyfieldname);
            recursiveSQl.append(" )");
            recursiveSQl.append(" select " + this.linkkeyfieldname + " as " + this.keyfieldname + " from " + this.cache_tableName + " where " + this.linkkeyfieldname + " is not null");
            if (this.includekeydata) {
                recursiveSQl.append(" union all ");
                recursiveSQl.append(" select " + this.keyfieldname + " from " + this.tablename).append(whereBuffer);
            }
        }
        return recursiveSQl.toString();
    }

    public RecursiveQuerySQL addQueryFields(String ... fieldnames) {
        for (String fieldname : fieldnames) {
            if ((fieldname = fieldname.trim()).equals("")) continue;
            if (fieldname.contains(",")) {
                this.addQueryFields(fieldname.split(","));
                continue;
            }
            this.queryfieldnames.add(fieldname);
        }
        return this;
    }

    public RecursiveQuerySQL addQueryFields(ArrayList<String> fieldnames) {
        return this.addQueryFields(fieldnames.toArray(new String[0]));
    }

    public Rows query() throws YosException {
        Rows rows = this.dbConnect.runSqlQuery(this.getSQL());
        if (this.queryfieldnames.size() == 0) {
            return rows;
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this.dbConnect, this.tablename, new String[0]);
        querySQL.addQueryFields(this.keyfieldname);
        querySQL.addQueryFields(this.queryfieldnames);
        querySQL.setWhere(this.keyfieldname, rows.toArrayList(this.keyfieldname));
        return querySQL.query();
    }
}

