package utility.wechat.work.receive.core;

import utility.wechat.work.Parameter;

/**
 * 处理用户发来的信息，并进行反馈
 *
 * @author Administrator
 */
public class ReturnHandle {
    String finalxml;
    String ToUserName;
    String FromUserName;
    String CreateTime;
    String Content;
    String MsgId;
    String AgentID;
    String returnXML;// 反馈的xml
    String Event;
    String EventKey;
    String PicUrl;
    String MediaId;
    String Format;
    String ThumbMediaId;
    String Location_X;
    String Location_Y;
    String Scale;
    String Label;
    String Latitude;
    String Longitude;
    String Precision;
    String ScanType;
    String ScanResult;
    String systemclient;

    public ReturnHandle(String systemclient, String finalxml) {
        this.finalxml = finalxml;
        this.systemclient = systemclient;
        ToUserName = GetXmlValues.get(finalxml, "ToUserName");
        FromUserName = GetXmlValues.get(finalxml, "FromUserName");
        CreateTime = GetXmlValues.get(finalxml, "CreateTime");
        AgentID = GetXmlValues.get(finalxml, "AgentID");
        if (getMsgType().equalsIgnoreCase(Parameter.MsgType.text)) {
            // 如果是text类型的消息，则获取相应的参数
            Content = GetXmlValues.get(finalxml, "Content");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            // 根据Content（消息内容）及AgentID（应用ID）判断进行不同的反馈。
            switchTextMsg(AgentID, Content);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.location)) {
            // 如果是location类型的消息，则获取相应的参数
            Location_X = GetXmlValues.get(finalxml, "Location_X");
            Location_Y = GetXmlValues.get(finalxml, "Location_Y");
            Scale = GetXmlValues.get(finalxml, "Scale");
            Label = GetXmlValues.get(finalxml, "Label");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            switchLocationMsg(AgentID, Location_X, Location_Y, Scale, Label);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.image)) {
            // 如果是image类型的消息，则获取相应的参数
            PicUrl = GetXmlValues.get(finalxml, "PicUrl");
            MediaId = GetXmlValues.get(finalxml, "MediaId");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            switchImageMsg(AgentID, PicUrl, MediaId);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.voice)) {
            // 如果是voice类型的消息，则获取相应的参数
            MediaId = GetXmlValues.get(finalxml, "MediaId");
            Format = GetXmlValues.get(finalxml, "Format");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            switchVoiceMsg(AgentID, MediaId, Format);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.video)) {
            // 如果是video类型的消息，则获取相应的参数
            MediaId = GetXmlValues.get(finalxml, "MediaId");
            ThumbMediaId = GetXmlValues.get(finalxml, "ThumbMediaId");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            switchVideoMsg(AgentID, MediaId, ThumbMediaId);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.shortvideo)) {
            // 如果是shortvideo类型的消息，则获取相应的参数
            MediaId = GetXmlValues.get(finalxml, "MediaId");
            ThumbMediaId = GetXmlValues.get(finalxml, "ThumbMediaId");
            MsgId = GetXmlValues.get(finalxml, "MsgId");
            switchShortvideoMsg(AgentID, MediaId, ThumbMediaId);
        } else if (getMsgType().equalsIgnoreCase(Parameter.MsgType.event)) {
            Event = GetXmlValues.get(finalxml, "Event");// 时间类型，按钮、链接
            // 如果是event类型的消息，则获取相应的参数
            String eventtype = getEventType();
            if (eventtype.equalsIgnoreCase(Parameter.EventType.CLICK)) {// 按钮点击事件
                EventKey = GetXmlValues.get(finalxml, "EventKey");// 事件值，根据不同的值做出相应的响应
                switchClickEventMsg(AgentID, EventKey);
            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.subscribe)) {// 成员关注/取消关注事件
                switchSubscribeEventMsg();
            } else if (eventtype.equalsIgnoreCase(Parameter.EventType.LOCATION)) {// 上报地理位置事件
                Latitude = GetXmlValues.get(finalxml, "Latitude");
                Longitude = GetXmlValues.get(finalxml, "Longitude");
                Precision = GetXmlValues.get(finalxml, "Precision");
                switchLocationEventMsg(AgentID,Latitude, Longitude, Precision);
            } else if (eventtype.equalsIgnoreCase(Parameter.EventType.VIEW)) {// 按钮点击事件
                EventKey = GetXmlValues.get(finalxml, "EventKey");// 网址
                switchViewEventMsg(AgentID, EventKey);
            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.scancode_push)) {// 扫码推事件的事件推送
                EventKey = GetXmlValues.get(finalxml, "EventKey");
                ScanType = GetXmlValues.get(finalxml, "ScanType");
                ScanResult = GetXmlValues.get(finalxml, "ScanResult");
                switchScancode_pushEventMsg(AgentID,EventKey, ScanType, ScanResult);
            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.scancode_waitmsg)) {// 扫码推事件且弹出“消息接收中”提示框的事件推送
                EventKey = GetXmlValues.get(finalxml, "EventKey");
                ScanType = GetXmlValues.get(finalxml, "ScanType");
                ScanResult = GetXmlValues.get(finalxml, "ScanResult");
                switchScancode_waitmsgEventMsg(AgentID,EventKey, ScanType, ScanResult);
            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.pic_sysphoto)) {// 弹出系统拍照发图的事件推送

            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.pic_photo_or_album)) {// 弹出拍照或者相册发图的事件推送

            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.pic_weixin)) {// 弹出拍照或者相册发图的事件推送

            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.location_select)) {// 弹出地理位置选择器的事件推送

            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.batch_job_result)) {// 异步任务完成事件推送

            } else if (eventtype
                    .equalsIgnoreCase(Parameter.EventType.enter_agent)) {// 成员进入应用的事件推送)
                EventKey = GetXmlValues.get(finalxml, "EventKey");
                switchEnter_agentEventMsg(AgentID,EventKey);
            }

        }
    }

    /**
     * 处理文字消息
     *
     * @param Content 文字内容
     */
    private void switchTextMsg(String AgentID, String Content) {
        returnXML = getAppClass().switchTextMsg(AgentID, Content, FromUserName,
                ToUserName);
    }

    /**
     * 处理点击事件消息
     *
     * @param EventKey 事件值
     * @throws ClassNotFoundException
     * @throws IllegalAccessException
     * @throws InstantiationException
     */
    private void switchClickEventMsg(String AgentID, String EventKey) {
        returnXML = getAppClass().switchClickEventMsg(AgentID, EventKey, FromUserName,
                ToUserName);
    }

    /**
     * 点击菜单跳转链接的事件推送
     *
     * @param EventKey
     */
    private void switchViewEventMsg(String AgentID, String EventKey) {
        returnXML = getAppClass().switchViewEventMsg(AgentID, EventKey, FromUserName,
                ToUserName);
    }

    /**
     * 成员进入应用的事件推送
     *
     * @param EventKey
     */
    private void switchEnter_agentEventMsg(String AgentID, String EventKey) {
        returnXML = getAppClass().switchEnter_agentEventMsg(AgentID,EventKey,
                FromUserName, ToUserName);

    }

    /**
     * 扫码推事件的事件推送
     *
     * @param EventKey
     */
    private void switchScancode_pushEventMsg(String AgentID,String EventKey, String ScanType,
                                             String ScanResult) {

        returnXML = getAppClass().switchScancode_pushEventMsg(AgentID,EventKey,
                ScanType, ScanResult, FromUserName, ToUserName);
    }

    /**
     * 扫码推事件且弹出“消息接收中”提示框的事件推送
     *
     * @param EventKey
     */
    private void switchScancode_waitmsgEventMsg(String AgentID,String EventKey,
                                                String ScanType, String ScanResult) {
        returnXML = getAppClass().switchScancode_waitmsgEventMsg(AgentID,EventKey,
                ScanType, ScanResult, FromUserName, ToUserName);
    }

    /**
     * 关注取消关注
     */
    private void switchSubscribeEventMsg() {
        returnXML = getAppClass().switchSubscribeEventMsg(AgentID,
                FromUserName, ToUserName);
    }

    /**
     * 位置
     *
     * @param Latitude
     * @param Longitude
     * @param Precision
     */
    private void switchLocationEventMsg(String AgentID,String Latitude, String Longitude,
                                        String Precision) {
        returnXML = getAppClass().switchLocationEventMsg(AgentID, Latitude,
                Longitude, Precision, FromUserName, ToUserName);
    }

    /**
     * 处理图片消息
     *
     * @param AgentID 应用ID
     */
    private void switchImageMsg(String AgentID, String PicUrl, String MediaId) {
        returnXML = getAppClass().switchImageMsg(AgentID,PicUrl, MediaId, FromUserName,
                ToUserName);
    }

    /**
     * 处理音频消息
     *
     * @param AgentID 应用ID
     * @param MediaId 语音媒体文件id，可以调用获取媒体文件接口拉取数据
     * @param Format  语音格式，如amr，speex等
     */
    private void switchVoiceMsg(String AgentID, String MediaId, String Format) {
        returnXML = getAppClass().switchVoiceMsg(AgentID,MediaId, Format, FromUserName,
                ToUserName);
    }

    /**
     * 处理视频消息
     *
     * @param AgentID 应用ID
     */
    private void switchVideoMsg(String AgentID, String MediaId,
                                String ThumbMediaId) {
        returnXML = getAppClass().switchVideoMsg(AgentID,MediaId, ThumbMediaId,
                FromUserName, ToUserName);
    }

    /**
     * 处理短视频消息
     *
     * @param AgentID 应用ID
     */
    private void switchShortvideoMsg(String AgentID, String MediaId,
                                     String ThumbMediaId) {
        returnXML = getAppClass().switchShortvideoMsg(AgentID,MediaId, ThumbMediaId,
                FromUserName, ToUserName);
    }

    /**
     * 处理位置消息
     *
     * @param AgentID 应用ID
     */
    private void switchLocationMsg(String AgentID, String Location_X,
                                   String Location_Y, String Scale, String Label) {
        returnXML = getAppClass().switchLocationMsg(AgentID,Location_X, Location_Y,
                Scale, Label, FromUserName, ToUserName);
    }

    private String getMsgType() {
        return GetXmlValues.get(finalxml, "MsgType");
    }

    private String getEventType() {
        return GetXmlValues.get(finalxml, "Event");
    }

    public String getReturnXML() {
        return returnXML;
    }

    private QYWechatMsgRecevier getAppClass() {
        QYWechatMsgRecevier QYWechatMsgRecevier = null;
        try {
            String work_messagingclasspath = Parameter.getWorkParameter(systemclient).getString("work_messagingclasspath");
            work_messagingclasspath = work_messagingclasspath.equals("") ? "utility.wechat.work.receive.DefaultMessaging" : work_messagingclasspath;
            Class<?> clazz = Class.forName(work_messagingclasspath);
            QYWechatMsgRecevier = (QYWechatMsgRecevier) clazz.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return QYWechatMsgRecevier;
    }
}
