package utility.wechat.work;

import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Row;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class GetAccessToken {

    private static HashMap<String, String> tokenMap = new HashMap<>();
    private static HashMap<String, Long> tokentimeMap = new HashMap<>();

    public static String get(String systemclient) throws YosException {
        long nowtime = System.currentTimeMillis();
        long Interval = (nowtime - tokentimeMap.getOrDefault(systemclient, 0L)) / (1000 * 60);//间隔时间,单位（分钟）
        if (Interval >= 30) {
            tokenMap.put(systemclient, getToken(systemclient));
            tokentimeMap.put(systemclient, nowtime);
        }
        return tokenMap.get(systemclient);
    }

    public static String get(String corpid, String corpsecret) throws YosException {
        String systemclient = "systemmonitor";
        long nowtime = System.currentTimeMillis();
        long Interval = (nowtime - tokentimeMap.getOrDefault(systemclient, 0L)) / (1000 * 60);//间隔时间,单位（分钟）
        if (Interval >= 30) {
            tokenMap.put(systemclient, getToken(corpid, corpsecret));
            tokentimeMap.put(systemclient, nowtime);
        }
        return tokenMap.get(systemclient);
    }


    private static String getToken(String systemclient) {
        String accessToken = "";
        try {
            Row row = Parameter.getWorkParameter(systemclient);
            if (!row.isEmpty()) {
                accessToken = getToken(row.getString("work_corpid"), row.getString("work_corpsecret"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }

    private static String getToken(String corpid, String corpsecret) {
        String accessToken = "";
        try {
            String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + corpid + "&corpsecret=" + corpsecret;
            URL urlGet = new URL(url);
            HttpURLConnection http = (HttpURLConnection) urlGet
                    .openConnection();

            http.setRequestMethod("GET"); // 必须是get方式请求
            http.setRequestProperty("Content-Type",
                    "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30
            System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30
            http.connect();
            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, StandardCharsets.UTF_8);
            JSONObject demoJson = JSONObject.parseObject(message);
            accessToken = demoJson.getString("access_token", true);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }
}
