package service;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.YosException;
import common.parameter.License;
import utility.tools.MessageMonitoringStation;
import utility.tools.WebRequest;

/**
 * ssl证书监控
 */
public class SSLCertCheck extends ServiceController {
    @Override
    public void serviceRun() throws Exception {
        License license = License.get();
        long VerifyDays = license.getVerifyDays();
        if (VerifyDays <= 30) {
            MessageMonitoringStation.send("\nYOS授权证书到期提醒：\n剩余" + VerifyDays + "天\n截止日期：" + getDate_Str(license.getExpiresDate()) + "\n");
        }

        String url = Parameter.get("system_rest_requesturl");
        if (!url.equals("") && url.startsWith("https")) {
            JSONObject object = WebRequest.getDomainCertificateInfo(url);
            if (!object.isEmpty()) {
                String name = object.getString("name");
                String enddate = object.getString("enddate");
                int days = object.getInteger("days");
                if (days <= 14) {
                    MessageMonitoringStation.send("\nSSL证书到期提醒：\n" + name + "\n剩余" + days + "天\n截止日期：" + enddate + "\n");
                }
            }
        }
    }
}
