package restcontroller.sysmanage.site;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;
import java.util.Set;

@API(title = "管理端-站点管理")
public class site extends Controller {
    public site(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "站点列表查询", apiversion = R.ID10019001.v1.class)
    public String query_siteList() throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_site");
        querySQL.setPage(pageSize, pageNumber);
        Rows siterows = querySQL.query();

        QuerySQL versionQuery = SQLFactory.createQuerySQL(this, "sys_version_sites").setTableAlias("t1");
        versionQuery.addJoinTable(JOINTYPE.inner, "sys_version", "t2", "t1.versionid=t2.versionid");
        versionQuery.addQueryFields("t1.siteid,t2.version");
        RowsMap siteversionRowsMap = versionQuery.query().toRowsMap("siteid");
        for (Row siterow : siterows) {
            ArrayList<String> versionList = siteversionRowsMap.get(siterow.getString("siteid")).toArrayList("version");
            if (versionList.isEmpty()) {
                versionList.add("默认版本");
            }
            siterow.put("version", versionList);
        }
        return getSucReturnObject().setData(siterows).toString();
    }

    @API(title = "站点详情查询", apiversion = R.ID10019101.v1.class)
    public String query_siteMain() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_site");
        querySQL.setWhere("siteuid", siteuid);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "站点新增、修改", apiversion = R.ID10019201.v1.class)
    public String insertormodify_site() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        String siteid = content.getString("siteid");
        String sitename = content.getString("sitename");
        String enterprisename = content.getString("enterprisename");
        String bucketname = content.getStringValue("bucketname", "sys_site");
        ArrayList<String> sqlist = new ArrayList<>();
        if (siteuid <= 0 || dbConnect.runSqlQuery("select siteuid from sys_site where siteuid=" + siteuid).isEmpty()) {
            siteuid = createTableID("sys_site");

            InsertSQL insert_site = SQLFactory.createInsertSQL(this, "sys_site");
            insert_site.setValue("siteuid", siteuid);
            insert_site.setValue("siteid", siteid);
            insert_site.setValue("sitename", sitename);
            insert_site.setValue("enterprisename", enterprisename);
            insert_site.setValue("bucketname", bucketname);
            insert_site.setValue("createby", username);
            insert_site.setDateValue("createdate");
            sqlist.add(insert_site.getSQL());

            long salematerialfolderid = createTableID("sys_attachment");
            {
                InsertSQL insert_attachment = SQLFactory.createInsertSQL(this, "sys_attachment");
                insert_attachment.setValue("attachmentid", salematerialfolderid);
                insert_attachment.setValue("siteid", siteid);
                insert_attachment.setValue("type", "sourcefile");
                insert_attachment.setValue("createby", "system");
                insert_attachment.setDateValue("createdate");
                insert_attachment.setValue("postfix", "folder");
                insert_attachment.setValue("document", "营销物料");
                insert_attachment.setValue("isfolder", 1);
                sqlist.add(insert_attachment.getSQL());
            }

            long appfolderid = createTableID("sys_attachment");
            {
                InsertSQL insert_attachment = SQLFactory.createInsertSQL(this, "sys_attachment");
                insert_attachment.setValue("attachmentid", appfolderid);
                insert_attachment.setValue("siteid", siteid);
                insert_attachment.setValue("type", "sourcefile");
                insert_attachment.setValue("createby", "system");
                insert_attachment.setDateValue("createdate");
                insert_attachment.setValue("postfix", "folder");
                insert_attachment.setValue("document", "应用附件");
                insert_attachment.setValue("isfolder", 1);
                sqlist.add(insert_attachment.getSQL());
            }

            {
                InsertSQL insert_site_parameter = SQLFactory.createInsertSQL(this, "sys_site_parameter");
                insert_site_parameter.setValue("siteid", siteid);
                insert_site_parameter.setValue("sys_site_parameterid", createTableID("sys_site_parameter"));
                insert_site_parameter.setValue("salematerialfolderid", salematerialfolderid);
                insert_site_parameter.setValue("appfolderid", appfolderid);
                insert_site_parameter.setValue("password_default", "e10adc3949ba59abbe56e057f20f883e");
                insert_site_parameter.setValue("accountprefix", siteid);
                sqlist.add(insert_site_parameter.getSQL());
            }

            {
                InsertSQL insert_department = SQLFactory.createInsertSQL(this, "sys_department");
                insert_department.setValue("siteid", siteid);
                insert_department.setValue("departmentid", createTableID("sys_department"));
                insert_department.setValue("depname", sitename);
                insert_department.setValue("isused", 1);
                insert_department.setValue("sequence", 1);
                sqlist.add(insert_department.getSQL());
            }

            if (isTableExists("sat_notice_class")) {
                InsertSQL insert_department = SQLFactory.createInsertSQL(this, "sat_notice_class");
                insert_department.setValue("siteid", siteid);
                insert_department.setValue("sat_notice_classid", createTableID("sat_notice_class"));
                insert_department.setValue("classname", "默认板块");
                insert_department.setValue("issystem", 1);
                insert_department.setValue("issecret", 0);
                sqlist.add(insert_department.getSQL());
            }

            Rows sysadministratorrows = dbConnect.runSqlQuery("select userid from sys_users where sysadministrator=1");
            for (Row row : sysadministratorrows) {
                InsertSQL insert_usersite = SQLFactory.createInsertSQL(this, "sys_usersite");
                insert_usersite.setValue("usersiteid", createTableID("sys_usersite"));
                insert_usersite.setValue("userid", row.getLong("userid"));
                insert_usersite.setValue("siteid", siteid);
                insert_usersite.setWhere("not exists (select *from sys_usersite where userid=" + row.getLong("userid") + " and siteid='" + siteid + "')");
                sqlist.add(insert_usersite.getSQL());
            }
            content.put("siteuid", siteuid);
        } else {
            UpdateSQL update_site = SQLFactory.createUpdateSQL(this, "sys_site");
            update_site.setValue("sitename", sitename);
            update_site.setValue("enterprisename", enterprisename);
            update_site.setValue("bucketname", bucketname);
            update_site.setWhere("siteuid", siteuid);
            sqlist.add(update_site.getSQL());
        }

        InsertSQL insert_usersite = SQLFactory.createInsertSQL(this, "sys_enterprise");
        insert_usersite.setValue("sys_enterpriseid", createTableID("sys_enterprise"));
        insert_usersite.setValue("siteid", siteid);
        insert_usersite.setValue("enterprisename", sitename);
        insert_usersite.setValue("ismain", 1);
        insert_usersite.setValue("authuserid", userid);
        insert_usersite.setWhere("not exists(select *from sys_enterprise where siteid='" + siteid + "' and ismain=1)");
        sqlist.add(insert_usersite.getSQL());

        dbConnect.runSqlUpdate(sqlist);
        return query_siteMain();
    }

    @API(title = "站点删除", apiversion = R.ID10019301.v1.class)
    public String delete_site() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        boolean dataclean = content.getBooleanValue("dataclean");//站点数据清空
        Rows rows = dbConnect.runSqlQuery("select * from sys_site where siteuid=" + siteuid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("站点不存在！").toString();
        }
        if (rows.get(0).getString("siteid").equalsIgnoreCase("YOSSYS")) {
            return getErrReturnObject().setErrMsg("该站点不可删除！").toString();
        }
        String site = rows.get(0).getString("siteid");
        ArrayList<String> sqlist = new ArrayList<>();
        sqlist.add("delete from sys_site_parameter where siteid='" + site + "'");
        sqlist.add("delete from sys_site where siteuid=" + siteuid);
        if (dataclean) {
            Rows deleteSQLRows = dbConnect.runSqlQuery("select concat('delete from ',table_name,' where siteid=''" + site + "''') as sqlstr from sys_objectcols where column_name='siteid'");
            for (Row deleteSQLRow : deleteSQLRows) {
                sqlist.add(deleteSQLRow.getString("sqlstr"));
            }
        }
        dbConnect.runSqlUpdate(sqlist);
        Parameter.cleanSiteParameter(site);
        return getSucReturnObject().toString();
    }


    @API(title = "站点参数信息查询", apiversion = R.ID10019401.v1.class)
    public String querySite_Parameter() throws YosException {
        String siteid = content.getString("siteid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_site_parameter where siteid='" + siteid + "'");
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到站点参数").toString();
        } else {
            {
                JSONArray orderdefaultaccountArray = rows.get(0).getJSONArray("orderdefaultaccount");

                Set<String> ordertypeSet = getOptionType("ordertype").keySet();
                for (String ordertype : ordertypeSet) {
                    boolean has = false;
                    for (Object o : orderdefaultaccountArray) {
                        JSONObject orderdefaultaccountObject = (JSONObject) o;
                        if (orderdefaultaccountObject.getString("ordertype").equalsIgnoreCase(ordertype)) {
                            has = true;
                            break;
                        }
                    }
                    if (!has) {
                        JSONObject orderdefaultaccountObject = new JSONObject();
                        orderdefaultaccountObject.put("ordertype", ordertype);
                        orderdefaultaccountArray.add(orderdefaultaccountObject);
                    }
                }

                rows.get(0).put("orderdefaultaccount", orderdefaultaccountArray);
            }
            {
                JSONArray orderdefaultrepeatArray = rows.get(0).getJSONArray("orderdefaultrepeat");

                Set<String> ordertypeSet = getOptionType("ordertype").keySet();
                for (String ordertype : ordertypeSet) {
                    boolean has = false;
                    for (Object o : orderdefaultrepeatArray) {
                        JSONObject orderdefaultrepeatObject = (JSONObject) o;
                        if (orderdefaultrepeatObject.getString("ordertype").equalsIgnoreCase(ordertype)) {
                            has = true;
                            break;
                        }
                    }
                    if (!has) {
                        JSONObject orderdefaultrepeatObject = new JSONObject();
                        orderdefaultrepeatObject.put("ordertype", ordertype);
                        orderdefaultrepeatArray.add(orderdefaultrepeatObject);
                    }
                }
                rows.get(0).put("orderdefaultrepeat", orderdefaultrepeatArray);
            }

            Rows sys_enterpriseRows = dbConnect.runSqlQuery("select sys_enterpriseid from sys_enterprise where siteid='" + siteid + "' and ismain=1");
            if (sys_enterpriseRows.isNotEmpty()) {
                rows.get(0).put("sys_enterpriseid", sys_enterpriseRows.get(0).getLong("sys_enterpriseid"));
            }
        }
        return getSucReturnObject().setData(rows.get(0)).toString();
    }

    @API(title = "站点参数信息更新", apiversion = R.ID10019501.v1.class)
    public String updateSite_Parameter() throws YosException {
        String siteid = content.getString("siteid");
        RowsMap tableColumnsMap = getTableColumns("sys_site_parameter");
        tableColumnsMap.remove("changeuserid");
        tableColumnsMap.remove("changeby");
        tableColumnsMap.remove("changedate");
        tableColumnsMap.remove("siteid");

        boolean isupdate = false;
        UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_site_parameter");
        for (String key : content.keySet()) {
            if (tableColumnsMap.containsKey(key)) {
                isupdate = true;
                String column_type = tableColumnsMap.get(key).get(0).getString("column_type").toLowerCase();
                switch (column_type) {
                    case "decimal": {
                        updateSQL.setValue(key, content.getBigDecimal(key).floatValue());
                        break;
                    }
                    case "int":
                    case "smallint": {
                        updateSQL.setValue(key, content.getIntValue(key));
                        break;
                    }
                    case "bigint": {
                        updateSQL.setValue(key, content.getLongValue(key));
                        break;
                    }
                    default: {
                        updateSQL.setValue(key, content.getString(key));
                        break;
                    }
                }
            }
        }
        updateSQL.setWhere("siteid", siteid);
        if (isupdate) {
            updateSQL.update();
        }
        Parameter.cleanSiteParameter(siteid);
        return querySite_Parameter();
    }

    @API(title = "站点账号默认密码设置", apiversion = R.ID10019601.v1.class)
    public String updateSite_defaultpassword() throws YosException {
        String siteid = content.getString("siteid");
        String password_default = content.getString("password_default");//新账号默认密码

        UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_site_parameter");
        updateSQL.setValue("password_default", password_default);
        updateSQL.setWhere("siteid", siteid);
        updateSQL.update();
        Parameter.cleanSiteParameter(siteid);
        return getSucReturnObject().toString();
    }

    @API(title = "站点角色查询")
    public String query_siteroleList() throws YosException {
        String siteid = content.getString("siteid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_role");
        querySQL.setSiteid(siteid);
        return getSucReturnObject().setData(querySQL.query()).toString();
    }
}
