package restcontroller.sysmanage.develop.sysmesage;

import beans.translate.Translate;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.ReturnObject_Code;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

public class sysmessage extends Controller {


    public sysmessage(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统消息注册查询", apiversion = R.ID10026501.v1.class)
    public String querySysMessageList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("code ='").append(whereObject.getString("condition")).append("' ");
                where.append("or content like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_sysmessage", "type", "code", "title", "content", "sysmessageid");
        querySQL.setWhere(where.toString());
        querySQL.setPage(pageSize, pageNumber);
        Rows messageRows = querySQL.query();
        Rows languageRows = dbConnect.runSqlQuery("select languagecode,languagename from sys_language where isused=1 and languagecode!='ZH'");

        for (Row messageRow : messageRows) {
            long sysmessageid = messageRow.getLong("sysmessageid");
            JSONArray translateArray = new JSONArray();
            for (Row languagerow : languageRows) {
                String languagecode = languagerow.getString("languagecode");
                String languagename = languagerow.getString("languagename");

                JSONObject languageObject = new JSONObject();
                languageObject.put("languagecode", languagecode);
                languageObject.put("languagename", languagename);
                languageObject.put("title", Translate.getTranslateRow(languagecode, "sys_sysmessage", sysmessageid, "title"));
                languageObject.put("content", Translate.getTranslateRow(languagecode, "sys_sysmessage", sysmessageid, "content"));
                translateArray.add(languageObject);
            }
            messageRow.put("translates", translateArray);
        }
        return getSucReturnObject().setData(messageRows).toString();
    }

    @API(title = "系统消息注册", apiversion = R.ID10026601.v1.class)
    public String updateSysMessage() throws YosException {
        long sysmessageid = content.getLongValue("sysmessageid");

        String type = content.getString("type");
        String code = content.getString("code");
        String title = content.getString("title");
        String content_str = content.getString("content");

        if (sysmessageid <= 0) {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_sysmessage");
            querySQL.setWhere("code", code);
            if (querySQL.query().isNotEmpty()) {
                return getErrReturnObject().setErrMsg("消息代码已存在，不可重复！").toString();
            }
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_sysmessage");
            insertSQL.setValue("type", type);
            insertSQL.setValue("code", code);
            insertSQL.setValue("title", title);
            insertSQL.setValue("content", content_str);
            insertSQL.insert();
        } else {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_sysmessage");
            querySQL.setWhere("code", code);
            querySQL.setWhere("sysmessageid!=" + sysmessageid);
            if (querySQL.query().isNotEmpty()) {
                return getErrReturnObject().setErrMsg("消息代码已存在，不可重复！").toString();
            }
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_sysmessage");
            updateSQL.setValue("type", type);
            updateSQL.setValue("title", title);
            updateSQL.setValue("content", content_str);
            updateSQL.setUniqueid(sysmessageid);
            updateSQL.update();

            ReturnObject_Code.messageMap.remove(code);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "系统消息注册删除", apiversion = R.ID10026701.v1.class)
    public String deleteSysMessage() throws YosException {
        long sysmessageid = content.getLongValue("sysmessageid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_sysmessage where sysmessageid=" + sysmessageid);
        list.add("delete from sys_translate where ownertable='sys_sysmessage' and ownerid=" + sysmessageid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "根据消息代码及语言代码查询系统消息", apiversion = R.ID10026801.v1.class)
    public String getSystemMessage() throws YosException {
        String code = content.getString("code");
        Rows rows = dbConnect.runSqlQuery("select *from sys_sysmessage where code='" + code + "'");
        if (rows.isNotEmpty()) {
            Row row = rows.get(0);
            long sysmessageid = row.getLong("sysmessageid");
            String title = row.getString("title");
            String content_str = row.getString("content");
            row.put("title", Translate.getTranslate(languagecode, "sys_sysmessage", sysmessageid, "title", title));
            row.put("content", Translate.getTranslate(languagecode, "sys_sysmessage", sysmessageid, "content", content_str));
            return getSucReturnObject().setData(row).toString();
        }
        return getErrReturnObject().toString();
    }

    @API(title = "根据语言代码获取所有的系统消息", apiversion = R.ID10026901.v1.class)
    public String getAllSystemMessage() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_sysmessage ");
        JSONObject object = new JSONObject();
        for (Row row : rows) {
            long sysmessageid = row.getLong("sysmessageid");
            String title = row.getString("title");
            String content_str = row.getString("content");
            row.put("title", Translate.getTranslate(languagecode, "sys_sysmessage", sysmessageid, "title", title));
            row.put("content", Translate.getTranslate(languagecode, "sys_sysmessage", sysmessageid, "content", content_str));
            object.put(row.getString("code"), row);
        }
        return getSucReturnObject().setData(object).toString();
    }
}
