package restcontroller.sysmanage.develop.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.*;
import restcontroller.R;
import restcontroller.sysmanage.develop.apimanage.ApiMonitor;

public class Api extends Controller {
    public Api(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "YOSapi接口参数更新", intervaltime = 2000, apiversion = R.ID10003401.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = ApiMonitor.class, method = {"queryApiList"})})
    public String updateApiParam() throws YosException {
        long apiid = content.getLong("apiid");
        int apiversion = content.getIntValue("apiversion", 1);
        long old_intervaltime = 0;
        JSONArray old_conditionfields = new JSONArray();
        Rows rows = dbConnect.runSqlQuery("select *from sys_api where apiid='" + apiid + "' and apiversion='" + apiversion + "'");
        if (rows.isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_api");
            insertSQL.setValue("apiid", apiid);
            insertSQL.setValue("apiversion", apiversion);
            if (content.containsKey("intervaltime")) {
                insertSQL.setValue("intervaltime", content.getLongValue("intervaltime"));
            }

            if (content.containsKey("conditionfields")) {
                insertSQL.setValue("conditionfields", content.getJSONArray("conditionfields"));
            }
            insertSQL.insert();
        } else {
            old_intervaltime = rows.get(0).getLong("intervaltime");
            old_conditionfields = rows.get(0).getJSONArray("conditionfields");

            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_api");
            if (content.containsKey("intervaltime")) {
                rowUpdate.setValue("intervaltime", content.getLongValue("intervaltime"));
            }
            if (content.containsKey("conditionfields")) {
                rowUpdate.setValue("conditionfields", content.getJSONArray("conditionfields"));
            }
            rowUpdate.setWhere("apiid", apiid);
            rowUpdate.setWhere("apiversion", apiversion);
            rowUpdate.update();
        }
        if (content.containsKey("intervaltime")) {
            if (content.getLongValue("intervaltime") != old_intervaltime) {
                YOSAPI.setApiIntervaltime(apiid, apiversion, content.getLongValue("intervaltime"));
            }
        }
        if (content.containsKey("conditionfields")) {
            if (!content.getJSONArray("conditionfields").toJSONString().equals(old_conditionfields.toJSONString())) {
                QuerySQL.defaultconditionfieldsMap.remove(apiid);
            }
        }
        return getSucReturnObject().toString();
    }
}
