package restcontroller.sysmanage.develop.adspace;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

@API(title = "广告位管理")
public class adspace extends Controller {
    public adspace(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "广告位查询", apiversion = R.ID10002701.v1.class)
    public String query_adspacelist() throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_adspace");
        return getSucReturnObject().setData(querySQL.query()).toString();
    }

    @API(title = "广告位新增修改", apiversion = R.ID10003001.v1.class)
    public String insertormodify_adspace() throws YosException {
        long sys_adspaceid = content.getLongValue("sys_adspaceid");//新增时传0
        String systemclient = content.getString("systemclient");
        String dimensional = content.getString("dimensional");
        int isused = content.getInteger("isused");
        String location = content.getString("location");
        String notes = content.getString("notes");
        if (content.getBooleanValue("isasync")) {
            Rows sys_adspaceRows = dbConnect.runSqlQuery("select * from sys_adspace where systemclient='" + systemclient + "' and location='" + location + "'");
            if (sys_adspaceRows.isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_adspace");
                insertSQL.setValue("sys_adspaceid", createTableID("sys_adspace"));
                insertSQL.setValue("systemclient", systemclient);
                insertSQL.setValue("location", location);
                insertSQL.setValue("dimensional", dimensional);
                insertSQL.setValue("notes", notes);
                insertSQL.setValue("isused", isused);
                insertSQL.insert();
            } else {
                sys_adspaceid = sys_adspaceRows.get(0).getLong("sys_adspaceid");
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_adspace");
                updateSQL.setValue("location", location);
                updateSQL.setValue("dimensional", dimensional);
                updateSQL.setValue("notes", notes);
                updateSQL.setValue("isused", isused);
                updateSQL.setWhere("sys_adspaceid", sys_adspaceid);
                updateSQL.update();
            }
            return getSucReturnObject().toString();
        } else {
            if (sys_adspaceid <= 0 || dbConnect.runSqlQuery("select *from sys_adspace where sys_adspaceid=" + sys_adspaceid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_adspace where systemclient='" + systemclient + "' and dimensional='" + dimensional + "' and location='" + location + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("同一操作端广告位不可重复").toString();
                }
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_adspace");
                insertSQL.setValue("sys_adspaceid", createTableID("sys_adspace"));
                insertSQL.setValue("systemclient", systemclient);
                insertSQL.setValue("location", location);
                insertSQL.setValue("dimensional", dimensional);
                insertSQL.setValue("notes", notes);
                insertSQL.setValue("isused", isused);
                insertSQL.insert();
            } else {
                if (dbConnect.runSqlQuery("select *from sys_adspace where sys_adspaceid!='" + sys_adspaceid + "' and systemclient='" + systemclient + "' and dimensional='" + dimensional + "' and location='" + location + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("同一操作端广告位不可重复").toString();
                }
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_adspace");
                updateSQL.setValue("location", location);
                updateSQL.setValue("dimensional", dimensional);
                updateSQL.setValue("notes", notes);
                updateSQL.setValue("isused", isused);
                updateSQL.setWhere("sys_adspaceid", sys_adspaceid);
                updateSQL.update();
            }
            return getSucReturnObject().toString();
        }
    }

    @API(title = "广告位删除", apiversion = R.ID10003101.v1.class)
    public String delete_adspace() throws YosException {
        long sys_adspaceid = content.getLong("sys_adspaceid");
        if (dbConnect.runSqlQuery("select * from sys_ad where sys_adspaceid=" + sys_adspaceid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("广告位已被使用，不可删除！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_adspace where sys_adspaceid=" + sys_adspaceid);
        return getSucReturnObject().toString();
    }
}
