package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_thirdapi_reqlog implements YosObject {
    @Override
    public String table_comment() {
        return "第三方接口调用记录";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_thirdapi_reqlogid");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("prodname", "产品名称", 50));
        list.add(new VarcharCol("apiname", "接口名称", 50));
        list.add(new VarcharCol("siteid", "站点ID", 50));
        list.add(new VarcharCol("createby", "调用人", 50));
        list.add(new DateTimeCol("createdate", "调用时间"));
        list.add(new LongTextCol("request", "请求内容"));
        list.add(new LongTextCol("response", "响应内容"));
        list.add(new DecimalCol("amount", "金额", 16, 2));
        return list;
    }
}
