package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_services implements YosObject {

    @Override
    public String table_comment() {
        return "自动任务表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("serviceid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new LongTextCol("errmessage", "错误内容"));
        arrayList.add(new SmallIntCol("isrestarting", "正在重启", 0));
        arrayList.add(new IntCol("restartcount", "重启次数", 0));
        arrayList.add(new DateTimeCol("nextruntime", "下一次执行时间"));
        arrayList.add(new IntCol("day_of_week", "周几"));
        arrayList.add(new IntCol("day_of_month", "几号"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
